/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.mongodb.audit;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.model.Sorts;
import com.mongodb.util.JSON;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.nuxeo.common.utils.TextTemplate;
import org.nuxeo.ecm.core.api.CursorService;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.ScrollResult;
import org.nuxeo.ecm.core.query.sql.model.Literals;
import org.nuxeo.ecm.core.query.sql.model.MultiExpression;
import org.nuxeo.ecm.core.query.sql.model.Operand;
import org.nuxeo.ecm.core.query.sql.model.Operator;
import org.nuxeo.ecm.core.query.sql.model.OrderByExpr;
import org.nuxeo.ecm.core.query.sql.model.OrderByList;
import org.nuxeo.ecm.core.query.sql.model.Predicate;
import org.nuxeo.ecm.core.query.sql.model.QueryBuilder;
import org.nuxeo.ecm.core.query.sql.model.Reference;
import org.nuxeo.ecm.core.uidgen.UIDGeneratorService;
import org.nuxeo.ecm.core.uidgen.UIDSequencer;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.impl.LogEntryImpl;
import org.nuxeo.ecm.platform.audit.service.AbstractAuditBackend;
import org.nuxeo.ecm.platform.audit.service.AuditBackend;
import org.nuxeo.ecm.platform.audit.service.BaseLogEntryProvider;
import org.nuxeo.ecm.platform.audit.service.NXAuditEventsService;
import org.nuxeo.ecm.platform.audit.service.extension.AuditBackendDescriptor;
import org.nuxeo.mongodb.audit.MongoDBAuditEntryReader;
import org.nuxeo.mongodb.audit.MongoDBAuditEntryWriter;
import org.nuxeo.mongodb.audit.MongoDBExtendedInfo;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.mongodb.MongoDBConnectionService;
import org.nuxeo.runtime.services.config.ConfigurationService;

public class MongoDBAuditBackend
extends AbstractAuditBackend
implements AuditBackend {
    private static final Log log = LogFactory.getLog(MongoDBAuditBackend.class);
    public static final String AUDIT_DATABASE_ID = "audit";
    public static final String COLLECTION_NAME_PROPERTY = "nuxeo.mongodb.audit.collection.name";
    public static final String DEFAULT_COLLECTION_NAME = "audit";
    public static final String SEQ_NAME = "audit";
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    protected MongoCollection<Document> collection;
    protected MongoDBLogEntryProvider provider = new MongoDBLogEntryProvider();
    protected CursorService<MongoCursor<Document>, Document, String> cursorService;

    public MongoDBAuditBackend(NXAuditEventsService component, AuditBackendDescriptor config) {
        super(component, config);
    }

    public MongoDBAuditBackend() {
    }

    public int getApplicationStartedOrder() {
        DefaultComponent component = (DefaultComponent)Framework.getRuntime().getComponent("org.nuxeo.runtime.mongodb.MongoDBComponent");
        return component.getApplicationStartedOrder() + 1;
    }

    public void onApplicationStarted() {
        log.info((Object)"Activate MongoDB backend for Audit");
        ConfigurationService configurationService = (ConfigurationService)Framework.getService(ConfigurationService.class);
        String collName = configurationService.getString(COLLECTION_NAME_PROPERTY, "audit");
        MongoDBConnectionService mongoService = (MongoDBConnectionService)Framework.getService(MongoDBConnectionService.class);
        MongoDatabase database = mongoService.getDatabase("audit");
        this.collection = database.getCollection(collName);
        this.collection.createIndex(Indexes.ascending((String[])new String[]{"docUUID"}));
        this.collection.createIndex(Indexes.ascending((String[])new String[]{"eventDate"}));
        this.collection.createIndex(Indexes.ascending((String[])new String[]{"eventId"}));
        this.collection.createIndex(Indexes.ascending((String[])new String[]{"docPath"}));
        this.cursorService = new CursorService(doc -> {
            Object id = doc.remove((Object)"_id");
            if (id != null) {
                doc.put("id", id);
            }
            return JSON.serialize((Object)doc);
        });
    }

    public void onApplicationStopped() {
        this.collection = null;
        this.cursorService.clear();
        this.cursorService = null;
    }

    public MongoCollection<Document> getAuditCollection() {
        return this.collection;
    }

    public List<LogEntry> queryLogs(QueryBuilder builder) {
        MultiExpression predicate = builder.predicate();
        OrderByList orders = builder.orders();
        long offset = builder.offset();
        long limit = builder.limit();
        Bson mgFilter = this.createFilter(predicate);
        Bson mgOrder = this.createSort(orders);
        this.logRequest(mgFilter, mgOrder);
        FindIterable iterable = this.collection.find(mgFilter).sort(mgOrder).skip((int)offset).limit((int)limit);
        return this.buildLogEntries((FindIterable<Document>)iterable);
    }

    protected Bson createFilter(MultiExpression andPredicate) {
        List predicates = andPredicate.predicates;
        Function<Operand, String> getFieldName = operand -> ((Reference)operand).name;
        getFieldName = getFieldName.andThen(this::getMongoDBKey);
        ArrayList<Bson> filterList = new ArrayList<Bson>(predicates.size());
        for (Predicate predicate : predicates) {
            String leftName = getFieldName.apply(predicate.lvalue);
            Operator operator = predicate.operator;
            Object rightValue = Literals.valueOf((Operand)predicate.rvalue);
            if (rightValue instanceof ZonedDateTime) {
                rightValue = Date.from(((ZonedDateTime)rightValue).toInstant());
            }
            if (Operator.EQ.equals((Object)operator)) {
                filterList.add(Filters.eq((String)leftName, (Object)rightValue));
                continue;
            }
            if (Operator.NOTEQ.equals((Object)operator)) {
                filterList.add(Filters.ne((String)leftName, (Object)rightValue));
                continue;
            }
            if (Operator.LT.equals((Object)operator)) {
                filterList.add(Filters.lt((String)leftName, (Object)rightValue));
                continue;
            }
            if (Operator.LTEQ.equals((Object)operator)) {
                filterList.add(Filters.lte((String)leftName, (Object)rightValue));
                continue;
            }
            if (Operator.GTEQ.equals((Object)operator)) {
                filterList.add(Filters.gte((String)leftName, (Object)rightValue));
                continue;
            }
            if (Operator.GT.equals((Object)operator)) {
                filterList.add(Filters.gt((String)leftName, (Object)rightValue));
                continue;
            }
            if (Operator.IN.equals((Object)operator)) {
                filterList.add(Filters.in((String)leftName, (Iterable)((List)rightValue)));
                continue;
            }
            if (!Operator.STARTSWITH.equals((Object)operator)) continue;
            filterList.add(Filters.regex((String)leftName, (String)("^" + Pattern.quote(String.valueOf(rightValue)))));
        }
        return Filters.and(filterList);
    }

    protected Bson createSort(OrderByList orders) {
        ArrayList<Bson> orderList = new ArrayList<Bson>(orders.size());
        for (OrderByExpr order : orders) {
            String name = this.getMongoDBKey(order.reference.name);
            if (order.isDescending) {
                orderList.add(Sorts.descending((String[])new String[]{name}));
                continue;
            }
            orderList.add(Sorts.ascending((String[])new String[]{name}));
        }
        return Sorts.orderBy(orderList);
    }

    protected String getMongoDBKey(String key) {
        if ("id".equals(key)) {
            return "_id";
        }
        return key;
    }

    public LogEntry getLogEntryByID(long id) {
        Document document = (Document)this.collection.find(Filters.eq((String)"_id", (Object)id)).first();
        if (document == null) {
            return null;
        }
        return MongoDBAuditEntryReader.read(document);
    }

    public List<?> nativeQuery(String query, Map<String, Object> params, int pageNb, int pageSize) {
        Bson filter = this.buildFilter(query, params);
        this.logRequest(filter, pageNb, pageSize);
        FindIterable iterable = this.collection.find(filter).skip(pageNb * pageSize).limit(pageSize);
        return this.buildLogEntries((FindIterable<Document>)iterable);
    }

    public Bson buildFilter(String query, Map<String, Object> params) {
        if (params != null && params.size() > 0) {
            query = this.expandQueryVariables(query, params);
        }
        return Document.parse((String)query);
    }

    public String expandQueryVariables(String query, Object[] params) {
        HashMap<String, Object> qParams = new HashMap<String, Object>();
        for (int i = 0; i < params.length; ++i) {
            query = query.replaceFirst("\\?", "\\${param" + i + "}");
            qParams.put("param" + i, params[i]);
        }
        return this.expandQueryVariables(query, qParams);
    }

    public String expandQueryVariables(String query, Map<String, Object> params) {
        if (params != null && params.size() > 0) {
            TextTemplate tmpl = new TextTemplate();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (value instanceof Calendar) {
                    tmpl.setVariable(key, dateFormat.format(((Calendar)value).getTime()));
                    continue;
                }
                if (value instanceof Date) {
                    tmpl.setVariable(key, dateFormat.format(value));
                    continue;
                }
                if (value == null) continue;
                tmpl.setVariable(key, value.toString());
            }
            query = tmpl.processText(query);
        }
        return query;
    }

    public List<LogEntry> queryLogsByPage(String[] eventIds, Date limit, String[] categories, String path, int pageNb, int pageSize) {
        ArrayList<Bson> list = new ArrayList<Bson>();
        if (eventIds != null && eventIds.length > 0) {
            if (eventIds.length == 1) {
                list.add(Filters.eq((String)"eventId", (Object)eventIds[0]));
            } else {
                list.add(Filters.in((String)"eventId", (Object[])eventIds));
            }
        }
        if (categories != null && categories.length > 0) {
            if (categories.length == 1) {
                list.add(Filters.eq((String)"category", (Object)categories[0]));
            } else {
                list.add(Filters.in((String)"category", (Object[])categories));
            }
        }
        if (path != null) {
            list.add(Filters.eq((String)"docPath", (Object)path));
        }
        if (limit != null) {
            list.add(Filters.lt((String)"eventDate", (Object)limit));
        }
        Bson filter = list.size() == 1 ? (Bson)list.get(0) : Filters.and(list);
        this.logRequest(filter, pageNb, pageSize);
        FindIterable iterable = this.collection.find(filter).skip(pageNb * pageSize).limit(pageSize);
        return this.buildLogEntries((FindIterable<Document>)iterable);
    }

    public void addLogEntries(List<LogEntry> entries) {
        if (entries.isEmpty()) {
            return;
        }
        UIDGeneratorService uidGeneratorService = (UIDGeneratorService)Framework.getService(UIDGeneratorService.class);
        UIDSequencer seq = uidGeneratorService.getSequencer();
        ArrayList<Document> documents = new ArrayList<Document>(entries.size());
        List block = seq.getNextBlock("audit", entries.size());
        for (int i = 0; i < entries.size(); ++i) {
            LogEntry entry = entries.get(i);
            entry.setId(((Long)block.get(i)).longValue());
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Indexing log entry Id: %s, with logDate : %s, for docUUID: %s ", entry.getId(), entry.getLogDate(), entry.getDocUUID()));
            }
            documents.add(MongoDBAuditEntryWriter.asDocument(entry));
        }
        this.collection.insertMany(documents);
    }

    public Long getEventsCount(String eventId) {
        return this.collection.countDocuments(Filters.eq((String)"eventId", (Object)eventId));
    }

    public long syncLogCreationEntries(String repoId, String path, Boolean recurs) {
        return this.syncLogCreationEntries(this.provider, repoId, path, recurs);
    }

    public ExtendedInfo newExtendedInfo(Serializable value) {
        return new MongoDBExtendedInfo(value);
    }

    private List<LogEntry> buildLogEntries(FindIterable<Document> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false).map(MongoDBAuditEntryReader::read).collect(Collectors.toList());
    }

    private void logRequest(Bson filter, Bson orderBy) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("MongoDB: FILTER " + filter + (String)(orderBy == null ? "" : " ORDER BY " + orderBy)));
        }
    }

    private void logRequest(Bson filter, int pageNb, int pageSize) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("MongoDB: FILTER " + filter + " OFFSET " + pageNb + " LIMIT " + pageSize));
        }
    }

    public void append(List<String> jsonEntries) {
        ArrayList<Document> entries = new ArrayList<Document>();
        for (String json : jsonEntries) {
            try {
                LogEntryImpl entry = (LogEntryImpl)OBJECT_MAPPER.readValue(json, LogEntryImpl.class);
                if (entry.getId() == 0L) {
                    throw new NuxeoException("A json entry has an empty id. entry=" + json);
                }
                Document doc = MongoDBAuditEntryWriter.asDocument((LogEntry)entry);
                entries.add(doc);
            }
            catch (IOException e) {
                throw new NuxeoException("Unable to deserialize json entry=" + json, (Throwable)e);
            }
        }
        this.collection.insertMany(entries);
    }

    public ScrollResult<String> scroll(QueryBuilder builder, int batchSize, int keepAliveSeconds) {
        MultiExpression predicate = builder.predicate();
        OrderByList orders = builder.orders();
        Bson mgFilter = this.createFilter(predicate);
        Bson mgOrder = this.createSort(orders);
        this.logRequest(mgFilter, mgOrder);
        MongoCursor cursor = this.collection.find(mgFilter).sort(mgOrder).batchSize(batchSize).iterator();
        String scrollId = this.cursorService.registerCursor((Object)cursor, batchSize, keepAliveSeconds);
        return this.scroll(scrollId);
    }

    public ScrollResult<String> scroll(String scrollId) {
        return this.cursorService.scroll(scrollId);
    }

    public class MongoDBLogEntryProvider
    implements BaseLogEntryProvider {
        public int removeEntries(String eventId, String pathPattern) {
            throw new UnsupportedOperationException("Not implemented yet!");
        }

        public void addLogEntry(LogEntry logEntry) {
            ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
            entries.add(logEntry);
            MongoDBAuditBackend.this.addLogEntries(entries);
        }
    }
}

