/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.group.processor;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.config.ReadOnlyContext;
import ro.isdc.wro.config.support.ContextPropagatingCallable;
import ro.isdc.wro.manager.callback.LifecycleCallbackRegistry;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.group.processor.Injector;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.decorator.DefaultProcessorDecorator;
import ro.isdc.wro.model.resource.processor.factory.ProcessorsFactory;
import ro.isdc.wro.model.resource.processor.support.ProcessingCriteria;
import ro.isdc.wro.model.resource.processor.support.ProcessingType;
import ro.isdc.wro.util.WroUtil;

public class PreProcessorExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(PreProcessorExecutor.class);
    @Inject
    private UriLocatorFactory uriLocatorFactory;
    @Inject
    private ProcessorsFactory processorsFactory;
    @Inject
    private ReadOnlyContext context;
    @Inject
    private LifecycleCallbackRegistry callbackRegistry;
    @Inject
    private Injector injector;
    private ExecutorService executor;

    public String processAndMerge(List<Resource> resources, boolean minimize) throws IOException {
        return this.processAndMerge(resources, ProcessingCriteria.create(ProcessingType.ALL, minimize));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processAndMerge(List<Resource> resources, ProcessingCriteria criteria) throws IOException {
        Validate.notNull((Object)criteria);
        LOG.debug("criteria: {}", (Object)criteria);
        this.callbackRegistry.onBeforeMerge();
        try {
            Validate.notNull(resources);
            LOG.debug("process and merge resources: {}", resources);
            StringBuffer result = new StringBuffer();
            if (this.shouldRunInParallel(resources)) {
                result.append(this.runInParallel(resources, criteria));
            } else {
                for (Resource resource : resources) {
                    LOG.debug("\tmerging resource: {}", (Object)resource);
                    result.append(this.applyPreProcessors(resource, criteria));
                }
            }
            String string = result.toString();
            return string;
        }
        finally {
            this.callbackRegistry.onAfterMerge();
        }
    }

    private boolean shouldRunInParallel(List<Resource> resources) {
        boolean isParallel = this.context.getConfig().isParallelPreprocessing();
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        return isParallel && resources.size() > 1 && availableProcessors > 1;
    }

    private String runInParallel(List<Resource> resources, final ProcessingCriteria criteria) throws IOException {
        LOG.debug("Running preProcessing in Parallel");
        StringBuffer result = new StringBuffer();
        ArrayList<1> callables = new ArrayList<1>();
        for (final Resource resource : resources) {
            callables.add(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    LOG.debug("Callable started for resource: {} ...", (Object)resource);
                    return PreProcessorExecutor.this.applyPreProcessors(resource, criteria);
                }
            });
        }
        ExecutorService exec = this.getExecutorService();
        ArrayList futures = new ArrayList();
        for (Callable callable : callables) {
            ContextPropagatingCallable decoratedCallable = new ContextPropagatingCallable(callable);
            futures.add(exec.submit(decoratedCallable));
        }
        for (Future future : futures) {
            try {
                result.append((String)future.get());
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause instanceof WroRuntimeException) {
                    throw (WroRuntimeException)cause;
                }
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                throw new WroRuntimeException("Problem during parallel pre processing", e);
            }
        }
        return result.toString();
    }

    private ExecutorService getExecutorService() {
        if (this.executor == null) {
            int threadPoolSize = Runtime.getRuntime().availableProcessors();
            LOG.debug("Parallel thread pool size: {}", (Object)threadPoolSize);
            this.executor = Executors.newFixedThreadPool(threadPoolSize, WroUtil.createDaemonThreadFactory("parallelPreprocessing"));
        }
        return this.executor;
    }

    private String applyPreProcessors(Resource resource, ProcessingCriteria criteria) throws IOException {
        Collection<ResourcePreProcessor> processors = this.processorsFactory.getPreProcessors();
        LOG.debug("applying preProcessors: {}", processors);
        String resourceContent = null;
        try {
            resourceContent = this.getResourceContent(resource);
        }
        catch (IOException e) {
            LOG.debug("Invalid resource found: {}", (Object)resource);
            if (Context.get().getConfig().isIgnoreMissingResources()) {
                return "";
            }
            LOG.error("Cannot ignore missing resource:  {}", (Object)resource);
            throw e;
        }
        if (!processors.isEmpty()) {
            StringWriter writer = null;
            for (ResourcePreProcessor processor : processors) {
                ResourcePreProcessor decoratedProcessor = this.decoratePreProcessor(processor, criteria);
                writer = new StringWriter();
                StringReader reader = new StringReader(resourceContent);
                decoratedProcessor.process(resource, reader, writer);
                resourceContent = ((Object)writer).toString();
            }
        }
        return String.format("%s%n", resourceContent);
    }

    private synchronized ResourcePreProcessor decoratePreProcessor(ResourcePreProcessor processor, ProcessingCriteria criteria) {
        DefaultProcessorDecorator decorated = new DefaultProcessorDecorator(processor, criteria){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void process(Resource resource, Reader reader, Writer writer) throws IOException {
                try {
                    PreProcessorExecutor.this.callbackRegistry.onBeforePreProcess();
                    super.process(resource, reader, writer);
                }
                finally {
                    PreProcessorExecutor.this.callbackRegistry.onAfterPreProcess();
                }
            }
        };
        this.injector.inject(decorated);
        return decorated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResourceContent(Resource resource) throws IOException {
        String string;
        BOMInputStream is = null;
        try {
            is = new BOMInputStream(this.uriLocatorFactory.locate(resource.getUri()));
            String result = IOUtils.toString((InputStream)is, (String)this.context.getConfig().getEncoding());
            if (StringUtils.isEmpty((CharSequence)result)) {
                LOG.debug("Empty resource detected: {}", (Object)resource.getUri());
            }
            string = result;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        return string;
    }

    public void destroy() {
        this.getExecutorService().shutdownNow();
    }
}

