/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.directory.server.core.schema.AbstractSchemaChangeHandler;
import org.apache.directory.server.core.schema.PartitionSchemaLoader;
import org.apache.directory.server.core.schema.SchemaEntityFactory;
import org.apache.directory.server.schema.bootstrap.Schema;
import org.apache.directory.server.schema.registries.ComparatorRegistry;
import org.apache.directory.server.schema.registries.MatchingRuleRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.exception.LdapInvalidNameException;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.exception.LdapOperationNotSupportedException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.syntax.ComparatorDescription;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.apache.directory.shared.ldap.util.Base64;
import org.apache.directory.shared.ldap.util.NamespaceTools;

public class MetaComparatorHandler
extends AbstractSchemaChangeHandler {
    private final SchemaEntityFactory factory;
    private final ComparatorRegistry comparatorRegistry;
    private final MatchingRuleRegistry matchingRuleRegistry;
    private final AttributeType byteCodeAT;
    private final AttributeType descAT;
    private final AttributeType fqcnAT;

    public MetaComparatorHandler(Registries targetRegistries, PartitionSchemaLoader loader) throws NamingException {
        super(targetRegistries, loader);
        this.comparatorRegistry = targetRegistries.getComparatorRegistry();
        this.matchingRuleRegistry = targetRegistries.getMatchingRuleRegistry();
        this.factory = new SchemaEntityFactory(targetRegistries);
        this.byteCodeAT = targetRegistries.getAttributeTypeRegistry().lookup("m-bytecode");
        this.descAT = targetRegistries.getAttributeTypeRegistry().lookup("m-description");
        this.fqcnAT = targetRegistries.getAttributeTypeRegistry().lookup("m-fqcn");
    }

    protected void modify(LdapDN name, Attributes entry, Attributes targetEntry, boolean cascade) throws NamingException {
        String oid = this.getOid(entry);
        Comparator comparator = this.factory.getComparator(targetEntry, this.targetRegistries);
        Schema schema = this.getSchema(name);
        if (!schema.isDisabled()) {
            this.comparatorRegistry.unregister(oid);
            ComparatorDescription description = this.getComparatorDescription(schema.getSchemaName(), targetEntry);
            this.comparatorRegistry.register(description, comparator);
        }
    }

    private ComparatorDescription getComparatorDescription(String schemaName, Attributes entry) throws NamingException {
        Attribute bytecode;
        ComparatorDescription description = new ComparatorDescription();
        description.setNumericOid(this.getOid(entry));
        ArrayList<String> values = new ArrayList<String>();
        values.add(schemaName);
        description.addExtension("X-SCHEMA", values);
        description.setFqcn((String)AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.fqcnAT).get());
        Attribute desc = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.descAT);
        if (desc != null && desc.size() > 0) {
            description.setDescription((String)desc.get());
        }
        if ((bytecode = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.byteCodeAT)) != null && bytecode.size() > 0) {
            byte[] bytes = (byte[])bytecode.get();
            description.setBytecode(new String(Base64.encode((byte[])bytes)));
        }
        return description;
    }

    public void add(LdapDN name, Attributes entry) throws NamingException {
        LdapDN parentDn = (LdapDN)name.clone();
        parentDn.remove(parentDn.size() - 1);
        this.checkNewParent(parentDn);
        this.checkOidIsUniqueForComparator(entry);
        Comparator comparator = this.factory.getComparator(entry, this.targetRegistries);
        Schema schema = this.getSchema(name);
        if (!schema.isDisabled()) {
            ComparatorDescription comparatorDescription = this.getComparatorDescription(schema.getSchemaName(), entry);
            this.comparatorRegistry.register(comparatorDescription, comparator);
        }
    }

    public void add(ComparatorDescription comparatorDescription) throws NamingException {
        Schema schema;
        Comparator comparator = this.factory.getComparator(comparatorDescription, this.targetRegistries);
        String schemaName = "other";
        if (comparatorDescription.getExtensions().get("X-SCHEMA") != null) {
            schemaName = (String)((List)comparatorDescription.getExtensions().get("X-SCHEMA")).get(0);
        }
        if (!(schema = this.loader.getSchema(schemaName)).isDisabled()) {
            this.comparatorRegistry.register(comparatorDescription, comparator);
        }
    }

    public void delete(LdapDN name, Attributes entry, boolean cascade) throws NamingException {
        String oid = this.getOid(entry);
        this.delete(oid, cascade);
    }

    public void delete(String oid, boolean cascade) throws NamingException {
        if (this.matchingRuleRegistry.hasMatchingRule(oid)) {
            throw new LdapOperationNotSupportedException("The comparator with OID " + oid + " cannot be deleted until all " + "matchingRules using that comparator have also been deleted.", ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        if (this.comparatorRegistry.hasComparator(oid)) {
            this.comparatorRegistry.unregister(oid);
        }
    }

    public void rename(LdapDN name, Attributes entry, String newRdn, boolean cascade) throws NamingException {
        String oldOid = this.getOid(entry);
        if (this.matchingRuleRegistry.hasMatchingRule(oldOid)) {
            throw new LdapOperationNotSupportedException("The comparator with OID " + oldOid + " cannot have it's OID changed until all " + "matchingRules using that comparator have been deleted.", ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        String oid = NamespaceTools.getRdnValue((String)newRdn);
        this.checkOidIsUniqueForComparator(oid);
        Schema schema = this.getSchema(name);
        if (!schema.isDisabled()) {
            Comparator comparator = this.factory.getComparator(entry, this.targetRegistries);
            this.comparatorRegistry.unregister(oldOid);
            ComparatorDescription comparatorDescription = this.getComparatorDescription(schema.getSchemaName(), entry);
            comparatorDescription.setNumericOid(oid);
            this.comparatorRegistry.register(comparatorDescription, comparator);
        }
    }

    public void move(LdapDN oriChildName, LdapDN newParentName, String newRn, boolean deleteOldRn, Attributes entry, boolean cascade) throws NamingException {
        this.checkNewParent(newParentName);
        String oldOid = this.getOid(entry);
        if (this.matchingRuleRegistry.hasMatchingRule(oldOid)) {
            throw new LdapOperationNotSupportedException("The comparator with OID " + oldOid + " cannot have it's OID changed until all " + "matchingRules using that comparator have been deleted.", ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        String oid = NamespaceTools.getRdnValue((String)newRn);
        this.checkOidIsUniqueForComparator(oid);
        Schema oldSchema = this.getSchema(oriChildName);
        Schema newSchema = this.getSchema(newParentName);
        Comparator comparator = this.factory.getComparator(entry, this.targetRegistries);
        if (!oldSchema.isDisabled()) {
            this.comparatorRegistry.unregister(oldOid);
        }
        if (!newSchema.isDisabled()) {
            ComparatorDescription comparatorDescription = this.getComparatorDescription(newSchema.getSchemaName(), entry);
            comparatorDescription.setNumericOid(oid);
            this.comparatorRegistry.register(comparatorDescription, comparator);
        }
    }

    public void replace(LdapDN oriChildName, LdapDN newParentName, Attributes entry, boolean cascade) throws NamingException {
        this.checkNewParent(newParentName);
        String oid = this.getOid(entry);
        if (this.matchingRuleRegistry.hasMatchingRule(oid)) {
            throw new LdapOperationNotSupportedException("The comparator with OID " + oid + " cannot be moved to another schema until all " + "matchingRules using that comparator have been deleted.", ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        Schema oldSchema = this.getSchema(oriChildName);
        Schema newSchema = this.getSchema(newParentName);
        Comparator comparator = this.factory.getComparator(entry, this.targetRegistries);
        if (!oldSchema.isDisabled()) {
            this.comparatorRegistry.unregister(oid);
        }
        if (!newSchema.isDisabled()) {
            ComparatorDescription comparatorDescription = this.getComparatorDescription(newSchema.getSchemaName(), entry);
            this.comparatorRegistry.register(comparatorDescription, comparator);
        }
    }

    private void checkOidIsUniqueForComparator(String oid) throws NamingException {
        if (this.targetRegistries.getComparatorRegistry().hasComparator(oid)) {
            throw new LdapNamingException("Oid " + oid + " for new schema comparator is not unique.", ResultCodeEnum.OTHER);
        }
    }

    private void checkOidIsUniqueForComparator(Attributes entry) throws NamingException {
        String oid = this.getOid(entry);
        if (this.targetRegistries.getComparatorRegistry().hasComparator(oid)) {
            throw new LdapNamingException("Oid " + oid + " for new schema comparator is not unique.", ResultCodeEnum.OTHER);
        }
    }

    private void checkNewParent(LdapDN newParent) throws NamingException {
        if (newParent.size() != 3) {
            throw new LdapInvalidNameException("The parent dn of a comparator should be at most 3 name components in length.", ResultCodeEnum.NAMING_VIOLATION);
        }
        Rdn rdn = newParent.getRdn();
        if (!this.targetRegistries.getOidRegistry().getOid(rdn.getNormType()).equals("2.5.4.11")) {
            throw new LdapInvalidNameException("The parent entry of a comparator should be an organizationalUnit.", ResultCodeEnum.NAMING_VIOLATION);
        }
        if (!((String)rdn.getValue()).equalsIgnoreCase("comparators")) {
            throw new LdapInvalidNameException("The parent entry of a comparator should have a relative name of ou=comparators.", ResultCodeEnum.NAMING_VIOLATION);
        }
    }
}

