/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.attribute.FileTime;
import java.time.LocalDate;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.naming.TimeLimitExceededException;
import net.openhft.chronicle.core.Jvm;

public interface LicenceCheck {
    public static final String CHRONICLE_LICENSE = "chronicle.license";

    public static void check(String product, Class caller) {
        Jvm.debug();
        String key = System.getProperty(CHRONICLE_LICENSE);
        if (key == null || !key.contains(product + '.')) {
            try {
                long date;
                URL location = caller.getProtectionDomain().getCodeSource().getLocation();
                String path = location.getPath();
                if (path.endsWith(".jar")) {
                    try (JarFile jarFile = new JarFile(path);){
                        JarEntry entry;
                        Enumeration<JarEntry> entries = jarFile.entries();
                        FileTime fileTime = null;
                        while (entries.hasMoreElements() && (fileTime = (entry = entries.nextElement()).getLastModifiedTime()) == null) {
                        }
                        date = fileTime.toMillis();
                    }
                } else {
                    File file = new File(path + caller.getName().replace(".", "/") + ".class");
                    date = file.lastModified();
                }
                long time = date - System.currentTimeMillis();
                long days = time / 86400000L + 92L;
                Jvm.warn().on(LicenceCheck.class, "Evaluation version expires in " + days + " days");
                if (days < 0L) {
                    throw new AssertionError((Object)new TimeLimitExceededException());
                }
            }
            catch (IOException e) {
                Jvm.warn().on(LicenceCheck.class, "Evaluation version expires in 1 day");
            }
        } else {
            int start = key.indexOf("expires=") + 8;
            int end = key.indexOf(",", start);
            LocalDate date = LocalDate.parse(key.substring(start, end));
            int start2 = key.indexOf("owner=") + 6;
            int end2 = key.indexOf(",", start2);
            String owner = key.substring(start2, end2);
            long days = date.toEpochDay() - System.currentTimeMillis() / 86400000L;
            Jvm.warn().on(LicenceCheck.class, "License for " + owner + " expires in " + days + " days");
            if (days < 0L) {
                throw new AssertionError((Object)new TimeLimitExceededException());
            }
        }
    }

    public void licenceCheck();

    public boolean isAvailable();
}

