/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.percentiles;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.metrics.percentiles.PercentilesAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.percentiles.PercentilesMethod;
import org.elasticsearch.search.aggregations.metrics.percentiles.hdr.HDRPercentileRanksAggregatorFactory;
import org.elasticsearch.search.aggregations.metrics.percentiles.tdigest.TDigestPercentileRanksAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceParserHelper;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.internal.SearchContext;

public class PercentileRanksAggregationBuilder
extends ValuesSourceAggregationBuilder.LeafOnly<ValuesSource.Numeric, PercentileRanksAggregationBuilder> {
    public static final String NAME = "percentile_ranks";
    public static final ParseField VALUES_FIELD = new ParseField("values", new String[0]);
    private static final ObjectParser<TDigestOptions, String> TDIGEST_OPTIONS_PARSER = new ObjectParser(PercentilesMethod.TDIGEST.getParseField().getPreferredName(), () -> new TDigestOptions());
    private static final ObjectParser<HDROptions, String> HDR_OPTIONS_PARSER;
    private static final ConstructingObjectParser<PercentileRanksAggregationBuilder, String> PARSER;
    private double[] values;
    private PercentilesMethod method = PercentilesMethod.TDIGEST;
    private int numberOfSignificantValueDigits = 3;
    private double compression = 100.0;
    private boolean keyed = true;

    public static AggregationBuilder parse(String aggregationName, XContentParser parser) throws IOException {
        return (AggregationBuilder)PARSER.parse(parser, (Object)aggregationName);
    }

    private PercentileRanksAggregationBuilder(String name, List<Double> values) {
        this(name, values.stream().mapToDouble(Double::doubleValue).toArray());
    }

    public PercentileRanksAggregationBuilder(String name, double[] values) {
        super(name, ValuesSourceType.NUMERIC, ValueType.NUMERIC);
        if (values == null) {
            throw new IllegalArgumentException("[values] must not be null: [" + name + "]");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException("[values] must not be an empty array: [" + name + "]");
        }
        double[] sortedValues = Arrays.copyOf(values, values.length);
        Arrays.sort(sortedValues);
        this.values = sortedValues;
    }

    protected PercentileRanksAggregationBuilder(PercentileRanksAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        super(clone, factoriesBuilder, metaData);
        this.values = clone.values;
        this.method = clone.method;
        this.numberOfSignificantValueDigits = clone.numberOfSignificantValueDigits;
        this.compression = clone.compression;
        this.keyed = clone.keyed;
    }

    @Override
    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        return new PercentileRanksAggregationBuilder(this, factoriesBuilder, metaData);
    }

    public PercentileRanksAggregationBuilder(StreamInput in) throws IOException {
        super(in, ValuesSourceType.NUMERIC, ValueType.NUMERIC);
        this.values = in.readDoubleArray();
        this.keyed = in.readBoolean();
        this.numberOfSignificantValueDigits = in.readVInt();
        this.compression = in.readDouble();
        this.method = PercentilesMethod.readFromStream(in);
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeDoubleArray(this.values);
        out.writeBoolean(this.keyed);
        out.writeVInt(this.numberOfSignificantValueDigits);
        out.writeDouble(this.compression);
        this.method.writeTo(out);
    }

    public double[] values() {
        return this.values;
    }

    public PercentileRanksAggregationBuilder keyed(boolean keyed) {
        this.keyed = keyed;
        return this;
    }

    public boolean keyed() {
        return this.keyed;
    }

    public PercentileRanksAggregationBuilder numberOfSignificantValueDigits(int numberOfSignificantValueDigits) {
        if (numberOfSignificantValueDigits < 0 || numberOfSignificantValueDigits > 5) {
            throw new IllegalArgumentException("[numberOfSignificantValueDigits] must be between 0 and 5: [" + this.name + "]");
        }
        this.numberOfSignificantValueDigits = numberOfSignificantValueDigits;
        return this;
    }

    public int numberOfSignificantValueDigits() {
        return this.numberOfSignificantValueDigits;
    }

    public PercentileRanksAggregationBuilder compression(double compression) {
        if (compression < 0.0) {
            throw new IllegalArgumentException("[compression] must be greater than or equal to 0. Found [" + compression + "] in [" + this.name + "]");
        }
        this.compression = compression;
        return this;
    }

    public double compression() {
        return this.compression;
    }

    public PercentileRanksAggregationBuilder method(PercentilesMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("[method] must not be null: [" + this.name + "]");
        }
        this.method = method;
        return this;
    }

    public PercentilesMethod method() {
        return this.method;
    }

    @Override
    protected ValuesSourceAggregatorFactory<ValuesSource.Numeric, ?> innerBuild(SearchContext context, ValuesSourceConfig<ValuesSource.Numeric> config, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        switch (this.method) {
            case TDIGEST: {
                return new TDigestPercentileRanksAggregatorFactory(this.name, config, this.values, this.compression, this.keyed, context, parent, subFactoriesBuilder, this.metaData);
            }
            case HDR: {
                return new HDRPercentileRanksAggregatorFactory(this.name, config, this.values, this.numberOfSignificantValueDigits, this.keyed, context, parent, subFactoriesBuilder, this.metaData);
            }
        }
        throw new IllegalStateException("Illegal method [" + this.method + "]");
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.array(VALUES_FIELD.getPreferredName(), this.values);
        builder.field(PercentilesAggregationBuilder.KEYED_FIELD.getPreferredName(), this.keyed);
        builder.startObject(this.method.toString());
        if (this.method == PercentilesMethod.TDIGEST) {
            builder.field(PercentilesAggregationBuilder.COMPRESSION_FIELD.getPreferredName(), this.compression);
        } else {
            builder.field(PercentilesAggregationBuilder.NUMBER_SIGNIFICANT_DIGITS_FIELD.getPreferredName(), this.numberOfSignificantValueDigits);
        }
        builder.endObject();
        return builder;
    }

    @Override
    protected boolean innerEquals(Object obj) {
        PercentileRanksAggregationBuilder other = (PercentileRanksAggregationBuilder)obj;
        if (!Objects.equals(this.method, other.method)) {
            return false;
        }
        boolean equalSettings = false;
        switch (this.method) {
            case HDR: {
                equalSettings = Objects.equals(this.numberOfSignificantValueDigits, other.numberOfSignificantValueDigits);
                break;
            }
            case TDIGEST: {
                equalSettings = Objects.equals(this.compression, other.compression);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal method [" + this.method + "]");
            }
        }
        return equalSettings && Objects.deepEquals(this.values, other.values) && Objects.equals(this.keyed, other.keyed) && Objects.equals(this.method, other.method);
    }

    @Override
    protected int innerHashCode() {
        switch (this.method) {
            case HDR: {
                return Objects.hash(Arrays.hashCode(this.values), this.keyed, this.numberOfSignificantValueDigits, this.method);
            }
            case TDIGEST: {
                return Objects.hash(Arrays.hashCode(this.values), this.keyed, this.compression, this.method);
            }
        }
        throw new IllegalStateException("Illegal method [" + this.method + "]");
    }

    @Override
    public String getType() {
        return NAME;
    }

    static {
        TDIGEST_OPTIONS_PARSER.declareDouble((opts, compression) -> {
            opts.compression = compression;
        }, new ParseField("compression", new String[0]));
        HDR_OPTIONS_PARSER = new ObjectParser(PercentilesMethod.HDR.getParseField().getPreferredName(), () -> new HDROptions());
        HDR_OPTIONS_PARSER.declareInt((opts, numberOfSigDigits) -> {
            opts.numberOfSigDigits = numberOfSigDigits;
        }, new ParseField("number_of_significant_value_digits", new String[0]));
        PARSER = new ConstructingObjectParser(NAME, false, (a, context) -> new PercentileRanksAggregationBuilder((String)context, (List)a[0]));
        ValuesSourceParserHelper.declareNumericFields(PARSER, true, false, false);
        PARSER.declareDoubleArray(ConstructingObjectParser.constructorArg(), VALUES_FIELD);
        PARSER.declareBoolean(PercentileRanksAggregationBuilder::keyed, PercentilesAggregationBuilder.KEYED_FIELD);
        PARSER.declareField((b, v) -> {
            b.method(PercentilesMethod.TDIGEST);
            if (v.compression != null) {
                b.compression(v.compression);
            }
        }, (arg_0, arg_1) -> TDIGEST_OPTIONS_PARSER.parse(arg_0, arg_1), PercentilesMethod.TDIGEST.getParseField(), ObjectParser.ValueType.OBJECT);
        PARSER.declareField((b, v) -> {
            b.method(PercentilesMethod.HDR);
            if (v.numberOfSigDigits != null) {
                b.numberOfSignificantValueDigits(v.numberOfSigDigits);
            }
        }, (arg_0, arg_1) -> HDR_OPTIONS_PARSER.parse(arg_0, arg_1), PercentilesMethod.HDR.getParseField(), ObjectParser.ValueType.OBJECT);
    }

    private static class HDROptions {
        Integer numberOfSigDigits;

        private HDROptions() {
        }
    }

    private static class TDigestOptions {
        Double compression;

        private TDigestOptions() {
        }
    }
}

