/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.audit.api.AuditLogger;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.impl.LogEntryImpl;
import org.nuxeo.lib.stream.computation.AbstractBatchComputation;
import org.nuxeo.lib.stream.computation.ComputationContext;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.computation.Topology;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.stream.StreamProcessorTopology;

public class StreamAuditWriter
implements StreamProcessorTopology {
    private static final Log log = LogFactory.getLog(StreamAuditWriter.class);
    public static final String COMPUTATION_NAME = "AuditLogWriter";

    public Topology getTopology(Map<String, String> options) {
        return Topology.builder().addComputation(() -> new AuditLogWriterComputation(COMPUTATION_NAME), Collections.singletonList("i1:audit")).build();
    }

    public static class AuditLogWriterComputation
    extends AbstractBatchComputation {
        public AuditLogWriterComputation(String name) {
            super(name, 1, 0);
        }

        public void batchProcess(ComputationContext context, String inputStreamName, List<Record> records) {
            ArrayList<LogEntry> logEntries = new ArrayList<LogEntry>(records.size());
            for (Record record : records) {
                try {
                    logEntries.add(this.getLogEntryFromJson(record.getData()));
                }
                catch (NuxeoException e) {
                    log.error((Object)("Discard invalid record: " + record), (Throwable)e);
                }
            }
            this.writeEntriesToAudit(logEntries);
        }

        public void batchFailure(ComputationContext context, String inputStreamName, List<Record> records) {
        }

        protected void writeEntriesToAudit(List<LogEntry> logEntries) {
            if (logEntries.isEmpty()) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Writing %d log entries to audit backend.", logEntries.size()));
            }
            AuditLogger logger = (AuditLogger)Framework.getService(AuditLogger.class);
            logger.addLogEntries(logEntries);
        }

        protected LogEntry getLogEntryFromJson(byte[] data) {
            String json = "";
            try {
                json = new String(data, StandardCharsets.UTF_8);
                ObjectMapper mapper = new ObjectMapper();
                return (LogEntry)mapper.readValue(json, LogEntryImpl.class);
            }
            catch (IOException e) {
                throw new NuxeoException("Invalid json logEntry" + json, (Throwable)e);
            }
        }
    }
}

