/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics5;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MetricName
implements Comparable<MetricName> {
    private static final String SEPARATOR = ".";
    private static final Map<String, String> EMPTY_TAGS = Collections.emptyMap();
    static final MetricName EMPTY = new MetricName("", EMPTY_TAGS);
    private final String key;
    private final Map<String, String> tags;

    public static MetricName empty() {
        return EMPTY;
    }

    public MetricName(String key, Map<String, String> tags) {
        this.key = Objects.requireNonNull(key);
        this.tags = tags.isEmpty() ? EMPTY_TAGS : MetricName.unmodifiableSortedCopy(tags);
    }

    public String getKey() {
        return this.key;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public MetricName resolve(String ... parts) {
        if (parts == null || parts.length == 0) {
            return this;
        }
        String newKey = Stream.concat(Stream.of(this.key), Stream.of(parts)).filter(s -> s != null && !s.isEmpty()).collect(Collectors.joining(SEPARATOR));
        return new MetricName(newKey, this.tags);
    }

    public MetricName tagged(Map<String, String> add) {
        HashMap<String, String> newTags = new HashMap<String, String>();
        newTags.putAll(this.tags);
        newTags.putAll(add);
        return new MetricName(this.key, newTags);
    }

    public MetricName tagged(String ... pairs) {
        if (pairs == null || pairs.length == 0) {
            return this;
        }
        if (pairs.length % 2 != 0) {
            throw new IllegalArgumentException("Argument count must be even");
        }
        HashMap<String, String> add = new HashMap<String, String>();
        for (int i = 0; i < pairs.length; i += 2) {
            add.put(pairs[i], pairs[i + 1]);
        }
        return this.tagged(add);
    }

    public MetricName append(MetricName append) {
        return this.resolve(append.key).tagged(append.tags);
    }

    public static MetricName build(String ... parts) {
        return EMPTY.resolve(parts);
    }

    public String toString() {
        return this.tags.isEmpty() ? this.key : this.key + this.tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricName that = (MetricName)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.tags, that.tags);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.tags);
    }

    @Override
    public int compareTo(MetricName o) {
        int c = this.key.compareTo(o.getKey());
        if (c != 0) {
            return c;
        }
        return this.compareTags(this.tags, o.getTags());
    }

    private int compareTags(Map<String, String> left, Map<String, String> right) {
        Iterator<Map.Entry<String, String>> lit = left.entrySet().iterator();
        Iterator<Map.Entry<String, String>> rit = right.entrySet().iterator();
        while (lit.hasNext() && rit.hasNext()) {
            Map.Entry<String, String> l = lit.next();
            Map.Entry<String, String> r = rit.next();
            int c = l.getKey().compareTo(r.getKey());
            if (c != 0) {
                return c;
            }
            if (l.getValue() == null && r.getValue() == null) {
                return 0;
            }
            if (l.getValue() == null) {
                return -1;
            }
            if (r.getValue() == null) {
                return 1;
            }
            c = l.getValue().compareTo(r.getValue());
            if (c == 0) continue;
            return c;
        }
        if (lit.hasNext()) {
            return 1;
        }
        if (rit.hasNext()) {
            return -1;
        }
        return 0;
    }

    private static <K extends Comparable<K>, V> Map<K, V> unmodifiableSortedCopy(Map<K, V> map) {
        LinkedHashMap sorted = new LinkedHashMap();
        map.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).forEach(e -> sorted.put((Comparable)e.getKey(), e.getValue()));
        return Collections.unmodifiableMap(sorted);
    }
}

