/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import java.util.ArrayList;
import java.util.List;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.SolverDecorator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LexicoDecorator<T extends ISolver>
extends SolverDecorator<T>
implements IOptimizationProblem {
    protected final List<IVecInt> criteria = new ArrayList<IVecInt>();
    protected int currentCriterion = 0;
    private IConstr prevConstr;
    private Number currentValue = new Integer(-1);
    protected int[] prevfullmodel;
    protected boolean[] prevboolmodel;
    private boolean isSolutionOptimal;
    private static final long serialVersionUID = 1L;

    public LexicoDecorator(T solver) {
        super(solver);
    }

    public void addCriterion(IVecInt literals) {
        VecInt copy = new VecInt(literals.size());
        literals.copyTo(copy);
        this.criteria.add(copy);
    }

    @Override
    public boolean admitABetterSolution() throws TimeoutException {
        return this.admitABetterSolution(VecInt.EMPTY);
    }

    @Override
    public boolean admitABetterSolution(IVecInt assumps) throws TimeoutException {
        this.isSolutionOptimal = false;
        if (this.decorated().isSatisfiable(assumps, true)) {
            this.prevboolmodel = new boolean[this.nVars()];
            int i = 0;
            while (i < this.nVars()) {
                this.prevboolmodel[i] = this.decorated().model(i + 1);
                ++i;
            }
            this.prevfullmodel = this.decorated().model();
            this.calculateObjective();
            return true;
        }
        return this.manageUnsatCase();
    }

    private boolean manageUnsatCase() {
        if (this.currentCriterion < this.numberOfCriteria() - 1) {
            if (this.prevConstr != null) {
                super.removeConstr(this.prevConstr);
                this.prevConstr = null;
            }
            try {
                this.fixCriterionValue();
            }
            catch (ContradictionException e) {
                throw new IllegalStateException(e);
            }
            if (this.isVerbose()) {
                System.out.println(new StringBuffer(String.valueOf(this.getLogPrefix())).append("Found optimal criterion number ").append(this.currentCriterion + 1).toString());
            }
            ++this.currentCriterion;
            this.calculateObjective();
            return true;
        }
        if (this.isVerbose()) {
            System.out.println(new StringBuffer(String.valueOf(this.getLogPrefix())).append("Found optimal solution for the last criterion ").toString());
        }
        this.isSolutionOptimal = true;
        if (this.prevConstr != null) {
            super.removeConstr(this.prevConstr);
            this.prevConstr = null;
        }
        return false;
    }

    protected int numberOfCriteria() {
        return this.criteria.size();
    }

    protected void fixCriterionValue() throws ContradictionException {
        super.addAtMost(this.criteria.get(this.currentCriterion), this.currentValue.intValue());
        super.addAtLeast(this.criteria.get(this.currentCriterion), this.currentValue.intValue());
    }

    @Override
    public int[] model() {
        return this.prevfullmodel;
    }

    @Override
    public boolean model(int var) {
        return this.prevboolmodel[var - 1];
    }

    @Override
    public boolean hasNoObjectiveFunction() {
        return false;
    }

    @Override
    public boolean nonOptimalMeansSatisfiable() {
        return true;
    }

    @Override
    public Number calculateObjective() {
        this.currentValue = this.evaluate();
        return this.currentValue;
    }

    @Override
    public Number getObjectiveValue() {
        return this.currentValue;
    }

    @Override
    public void forceObjectiveValueTo(Number forcedValue) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void discard() throws ContradictionException {
        this.discardCurrentSolution();
    }

    @Override
    public void discardCurrentSolution() throws ContradictionException {
        block3: {
            if (this.prevConstr != null) {
                super.removeSubsumedConstr(this.prevConstr);
            }
            try {
                this.prevConstr = this.discardSolutionsForOptimizing();
            }
            catch (ContradictionException c) {
                this.prevConstr = null;
                if (this.manageUnsatCase()) break block3;
                throw c;
            }
        }
    }

    protected IConstr discardSolutionsForOptimizing() throws ContradictionException {
        return super.addAtMost(this.criteria.get(this.currentCriterion), this.currentValue.intValue() - 1);
    }

    protected Number evaluate() {
        int value = 0;
        IteratorInt it = this.criteria.get(this.currentCriterion).iterator();
        while (it.hasNext()) {
            int lit = it.next();
            if ((lit <= 0 || !this.prevboolmodel[lit - 1]) && (lit >= 0 || this.prevboolmodel[-lit - 1])) continue;
            ++value;
        }
        return new Integer(value);
    }

    @Override
    public boolean isOptimal() {
        return this.isSolutionOptimal;
    }
}

