/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.comment.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.comment.api.Annotation;
import org.nuxeo.ecm.platform.comment.api.AnnotationService;
import org.nuxeo.ecm.platform.comment.api.Comment;
import org.nuxeo.ecm.platform.comment.api.CommentManager;
import org.nuxeo.ecm.platform.comment.api.exceptions.CommentNotFoundException;
import org.nuxeo.ecm.platform.comment.api.exceptions.CommentSecurityException;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class AnnotationServiceImpl
extends DefaultComponent
implements AnnotationService {
    @Deprecated(since="11.1")
    protected static final String GET_ANNOTATION_PAGEPROVIDER_NAME = "GET_ANNOTATION_AS_EXTERNAL_ENTITY";
    protected static final String GET_ANNOTATIONS_FOR_DOC_PAGEPROVIDER_NAME = "GET_ANNOTATIONS_FOR_DOCUMENT";

    public Annotation createAnnotation(CoreSession session, Annotation annotation) throws CommentSecurityException {
        return (Annotation)((CommentManager)Framework.getService(CommentManager.class)).createComment(session, (Comment)annotation);
    }

    public Annotation getAnnotation(CoreSession s, String annotationId) throws CommentNotFoundException, CommentSecurityException {
        return (Annotation)((CommentManager)Framework.getService(CommentManager.class)).getComment(s, annotationId);
    }

    public List<Annotation> getAnnotations(CoreSession session, String documentId, String xpath) throws CommentNotFoundException, CommentSecurityException {
        IdRef docRef = new IdRef(documentId);
        try {
            if (!session.hasPermission((DocumentRef)docRef, "Read")) {
                throw new CommentSecurityException("The user " + session.getPrincipal().getName() + " does not have access to the annotations of document " + documentId);
            }
        }
        catch (DocumentNotFoundException dnfe) {
            throw new CommentNotFoundException(String.format("The document %s does not exist.", docRef), (Throwable)dnfe);
        }
        DocumentModel annotatedDoc = session.getDocument((DocumentRef)docRef);
        CommentManager commentManager = (CommentManager)Framework.getService(CommentManager.class);
        if (commentManager.hasFeature(CommentManager.Feature.COMMENTS_LINKED_WITH_PROPERTY)) {
            PageProviderService ppService = (PageProviderService)Framework.getService(PageProviderService.class);
            return (List)CoreInstance.doPrivileged((CoreSession)session, s -> {
                Map<String, Serializable> props = Collections.singletonMap("coreSession", (Serializable)s);
                PageProvider pageProvider = ppService.getPageProvider(GET_ANNOTATIONS_FOR_DOC_PAGEPROVIDER_NAME, null, null, null, props, new Object[]{documentId, xpath});
                return pageProvider.getCurrentPage().stream().map(doc -> (Annotation)doc.getAdapter(Annotation.class)).collect(Collectors.toList());
            });
        }
        return (List)CoreInstance.doPrivileged((CoreSession)session, s -> commentManager.getComments(s, annotatedDoc).stream().filter(annotationModel -> "Annotation".equals(annotationModel.getType()) && xpath.equals(annotationModel.getPropertyValue("annotation:xpath"))).map(doc -> (Annotation)doc.getAdapter(Annotation.class)).collect(Collectors.toList()));
    }

    public void updateAnnotation(CoreSession session, String annotationId, Annotation annotation) throws CommentNotFoundException, CommentSecurityException {
        ((CommentManager)Framework.getService(CommentManager.class)).updateComment(session, annotationId, (Comment)annotation);
    }

    public void deleteAnnotation(CoreSession session, String annotationId) throws CommentNotFoundException {
        ((CommentManager)Framework.getService(CommentManager.class)).deleteComment(session, annotationId);
    }

    public Annotation getExternalAnnotation(CoreSession session, String entityId) throws CommentNotFoundException, CommentSecurityException {
        return (Annotation)((CommentManager)Framework.getService(CommentManager.class)).getExternalComment(session, entityId);
    }

    public void updateExternalAnnotation(CoreSession session, String entityId, Annotation annotation) throws CommentNotFoundException, CommentSecurityException {
        ((CommentManager)Framework.getService(CommentManager.class)).updateExternalComment(session, entityId, (Comment)annotation);
    }

    public void deleteExternalAnnotation(CoreSession session, String entityId) throws CommentNotFoundException, CommentSecurityException {
        ((CommentManager)Framework.getService(CommentManager.class)).deleteExternalComment(session, entityId);
    }

    @Deprecated(since="11.1", forRemoval=true)
    protected DocumentModel getAnnotationModel(CoreSession session, String entityId) {
        PageProviderService ppService = (PageProviderService)Framework.getService(PageProviderService.class);
        Map<String, Serializable> props = Collections.singletonMap("coreSession", (Serializable)session);
        List results = ppService.getPageProvider(GET_ANNOTATION_PAGEPROVIDER_NAME, null, Long.valueOf(1L), Long.valueOf(0L), props, new Object[]{entityId}).getCurrentPage();
        if (results.isEmpty()) {
            return null;
        }
        return (DocumentModel)results.get(0);
    }
}

