/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.comment.impl;

import java.io.Serializable;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PartialList;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.io.marshallers.json.document.DocumentModelJsonReader;
import org.nuxeo.ecm.platform.comment.api.Comment;
import org.nuxeo.ecm.platform.comment.api.CommentManager;
import org.nuxeo.ecm.platform.comment.api.exceptions.CommentNotFoundException;
import org.nuxeo.ecm.platform.comment.api.exceptions.CommentSecurityException;
import org.nuxeo.ecm.platform.comment.impl.AbstractCommentManager;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.runtime.api.Framework;

@Deprecated(since="11.1")
public class PropertyCommentManager
extends AbstractCommentManager {
    protected static final String GET_COMMENT_PAGEPROVIDER_NAME = "GET_COMMENT_AS_EXTERNAL_ENTITY";
    protected static final String GET_COMMENTS_FOR_DOC_PAGEPROVIDER_NAME = "GET_COMMENTS_FOR_DOCUMENT";
    protected static final String HIDDEN_FOLDER_TYPE = "HiddenFolder";
    protected static final String COMMENT_NAME = "comment";

    public List<DocumentModel> getComments(CoreSession session, DocumentModel docModel) throws CommentSecurityException {
        DocumentRef docRef = this.getAncestorRef(session, docModel);
        if (session.exists(docRef) && !session.hasPermission(docRef, "Read")) {
            throw new CommentSecurityException("The user " + session.getPrincipal().getName() + " does not have access to the comments of document " + docModel.getId());
        }
        PageProviderService ppService = (PageProviderService)Framework.getService(PageProviderService.class);
        return (List)CoreInstance.doPrivileged((CoreSession)session, s -> {
            Map<String, Serializable> props = Collections.singletonMap("coreSession", (Serializable)s);
            PageProvider pageProvider = ppService.getPageProvider(GET_COMMENTS_FOR_DOC_PAGEPROVIDER_NAME, Collections.singletonList(new SortInfo("comment:creationDate", true)), null, null, props, new Object[]{docModel.getId()});
            return pageProvider.getCurrentPage();
        });
    }

    @Override
    public List<DocumentModel> getComments(DocumentModel docModel, DocumentModel parent) {
        throw new UnsupportedOperationException("This service implementation does not implement deprecated API.");
    }

    public DocumentModel createComment(DocumentModel docModel, String comment) {
        throw new UnsupportedOperationException("This service implementation does not implement deprecated API.");
    }

    public DocumentModel createComment(DocumentModel docModel, String text, String author) {
        throw new UnsupportedOperationException("This service implementation does not implement deprecated API.");
    }

    public DocumentModel createComment(DocumentModel docModel, DocumentModel commentModel) throws CommentSecurityException {
        DocumentRef docRef;
        NuxeoPrincipal principal = commentModel.getPrincipal();
        CoreSession session = CoreInstance.getCoreSessionSystem((String)docModel.getRepositoryName());
        if (!session.hasPermission(principal, docRef = this.getTopLevelDocumentRef(session, docModel.getRef()), "Read")) {
            throw new CommentSecurityException("The user " + principal.getName() + " can not create comments on document " + docModel.getId());
        }
        String path = this.getCommentContainerPath(session, docModel.getId());
        DocumentModel commentModelToCreate = session.createDocumentModel(path, COMMENT_NAME, commentModel.getType());
        commentModelToCreate.copyContent(commentModel);
        commentModelToCreate.setPropertyValue("comment:parentId", (Serializable)((Object)docModel.getId()));
        commentModelToCreate.setPropertyValue("comment:ancestorIds", (Serializable)this.computeAncestorIds(session, docModel.getId()));
        DocumentModel comment = session.createDocument(commentModelToCreate);
        comment.detach(true);
        this.notifyEvent(session, "commentAdded", docModel, comment);
        return comment;
    }

    public DocumentModel createComment(DocumentModel docModel, DocumentModel parent, DocumentModel child) {
        throw new UnsupportedOperationException("This service implementation does not implement deprecated API.");
    }

    public void deleteComment(DocumentModel docModel, DocumentModel comment) {
        throw new UnsupportedOperationException("This service implementation does not implement deprecated API.");
    }

    public List<DocumentModel> getDocumentsForComment(DocumentModel comment) {
        throw new UnsupportedOperationException("This service implementation does not implement deprecated API.");
    }

    public DocumentModel getThreadForComment(DocumentModel comment) throws CommentSecurityException {
        return this.getThreadForComment(comment.getCoreSession(), comment);
    }

    public DocumentModel createLocatedComment(DocumentModel docModel, DocumentModel comment, String path) {
        DocumentRef docRef;
        CoreSession session = docModel.getCoreSession();
        if (!session.hasPermission(docRef = this.getTopLevelDocumentRef(session, docModel.getRef()), "Read")) {
            throw new CommentSecurityException("The user " + session.getPrincipal().getName() + " can not create comments on document " + docModel.getId());
        }
        return (DocumentModel)CoreInstance.doPrivileged((CoreSession)session, s -> {
            DocumentModel commentModel = s.createDocumentModel(path, COMMENT_NAME, comment.getType());
            commentModel.copyContent(comment);
            commentModel.setPropertyValue("comment:parentId", (Serializable)((Object)docModel.getId()));
            commentModel.setPropertyValue("comment:ancestorIds", (Serializable)this.computeAncestorIds((CoreSession)s, docModel.getId()));
            commentModel = s.createDocument(commentModel);
            this.notifyEvent(session, "commentAdded", docModel, commentModel);
            return commentModel;
        });
    }

    public Comment createComment(CoreSession session, Comment comment) throws CommentNotFoundException, CommentSecurityException {
        String parentId = comment.getParentId();
        IdRef parentRef = new IdRef(parentId);
        if (!((Boolean)CoreInstance.doPrivileged((CoreSession)session, arg_0 -> PropertyCommentManager.lambda$createComment$2((DocumentRef)parentRef, arg_0))).booleanValue()) {
            throw new CommentNotFoundException("The document or comment " + comment.getParentId() + " does not exist.");
        }
        DocumentRef ancestorRef = (DocumentRef)CoreInstance.doPrivileged((CoreSession)session, arg_0 -> this.lambda$createComment$3((DocumentRef)parentRef, arg_0));
        if (!session.hasPermission(ancestorRef, "Read")) {
            throw new CommentSecurityException("The user " + session.getPrincipal().getName() + " can not create comments on document " + parentId);
        }
        if (comment.getCreationDate() == null) {
            comment.setCreationDate(Instant.now());
        }
        return (Comment)CoreInstance.doPrivileged((CoreSession)session, s -> {
            String path = this.getCommentContainerPath((CoreSession)s, parentId);
            DocumentModel commentModel = session.createDocumentModel(path, COMMENT_NAME, comment.getDocument().getType());
            if (comment.getDocument().hasFacet("ExternalEntity")) {
                commentModel.addFacet("ExternalEntity");
            }
            DocumentModelJsonReader.applyDirtyPropertyValues((DocumentModel)comment.getDocument(), (DocumentModel)commentModel);
            commentModel.setPropertyValue("comment:ancestorIds", (Serializable)this.computeAncestorIds((CoreSession)s, parentId));
            commentModel = s.createDocument(commentModel);
            this.notifyEvent((CoreSession)s, "commentAdded", commentModel);
            return (Comment)commentModel.getAdapter(Comment.class);
        });
    }

    public Comment getComment(CoreSession session, String commentId) throws CommentNotFoundException, CommentSecurityException {
        IdRef commentRef = new IdRef(commentId);
        if (!((Boolean)CoreInstance.doPrivileged((CoreSession)session, arg_0 -> PropertyCommentManager.lambda$getComment$5((DocumentRef)commentRef, arg_0))).booleanValue()) {
            throw new CommentNotFoundException("The comment " + commentId + " does not exist.");
        }
        NuxeoPrincipal principal = session.getPrincipal();
        return (Comment)CoreInstance.doPrivileged((CoreSession)session, arg_0 -> this.lambda$getComment$6((DocumentRef)commentRef, principal, arg_0));
    }

    public PartialList<Comment> getComments(CoreSession session, String documentId, Long pageSize, Long currentPageIndex, boolean sortAscending) throws CommentSecurityException {
        IdRef docRef = new IdRef(documentId);
        PageProviderService ppService = (PageProviderService)Framework.getService(PageProviderService.class);
        NuxeoPrincipal principal = session.getPrincipal();
        return (PartialList)CoreInstance.doPrivileged((CoreSession)session, arg_0 -> this.lambda$getComments$9((DocumentRef)docRef, principal, documentId, ppService, sortAscending, pageSize, currentPageIndex, arg_0));
    }

    public Comment updateComment(CoreSession session, String commentId, Comment comment) throws CommentNotFoundException {
        IdRef commentRef = new IdRef(commentId);
        if (!((Boolean)CoreInstance.doPrivileged((CoreSession)session, s -> s.exists((DocumentRef)commentRef))).booleanValue()) {
            throw new CommentNotFoundException("The comment " + commentId + " does not exist.");
        }
        NuxeoPrincipal principal = session.getPrincipal();
        if (!principal.isAdministrator() && !comment.getAuthor().equals(principal.getName())) {
            throw new CommentSecurityException("The user " + principal.getName() + " cannot edit comments of document " + comment.getParentId());
        }
        return (Comment)CoreInstance.doPrivileged((CoreSession)session, s -> {
            if (comment.getModificationDate() == null) {
                comment.setModificationDate(Instant.now());
            }
            DocumentModel commentModel = s.getDocument((DocumentRef)commentRef);
            if (comment.getDocument().hasFacet("ExternalEntity")) {
                commentModel.addFacet("ExternalEntity");
            }
            DocumentModelJsonReader.applyDirtyPropertyValues((DocumentModel)comment.getDocument(), (DocumentModel)commentModel);
            s.saveDocument(commentModel);
            this.notifyEvent((CoreSession)s, "commentUpdated", commentModel);
            return (Comment)commentModel.getAdapter(Comment.class);
        });
    }

    public void deleteComment(CoreSession session, String commentId) throws CommentNotFoundException, CommentSecurityException {
        IdRef commentRef = new IdRef(commentId);
        if (!((Boolean)CoreInstance.doPrivileged((CoreSession)session, s -> s.exists((DocumentRef)commentRef))).booleanValue()) {
            throw new CommentNotFoundException("The comment " + commentId + " does not exist.");
        }
        NuxeoPrincipal principal = session.getPrincipal();
        CoreInstance.doPrivileged((CoreSession)session, s -> {
            DocumentModel comment = s.getDocument((DocumentRef)commentRef);
            String parentId = (String)((Object)comment.getPropertyValue("comment:parentId"));
            DocumentRef ancestorRef = this.getTopLevelDocumentRef((CoreSession)s, (DocumentRef)commentRef);
            if (s.exists(ancestorRef) && !principal.isAdministrator() && !comment.getPropertyValue("comment:author").equals(principal.getName()) && !s.hasPermission(principal, ancestorRef, "Everything")) {
                throw new CommentSecurityException("The user " + principal.getName() + " cannot delete comments of the document " + parentId);
            }
            comment.detach(true);
            s.removeDocument((DocumentRef)commentRef);
            this.notifyEvent((CoreSession)s, "commentRemoved", comment);
        });
    }

    public Comment getExternalComment(CoreSession session, String entityId) throws CommentNotFoundException {
        DocumentModel commentModel = this.getExternalCommentModel(session, entityId);
        if (commentModel == null) {
            throw new CommentNotFoundException("The external comment " + entityId + " does not exist.");
        }
        String parentId = (String)((Object)commentModel.getPropertyValue("comment:parentId"));
        if (!session.hasPermission(this.getTopLevelDocumentRef(session, commentModel.getRef()), "Read")) {
            throw new CommentSecurityException("The user " + session.getPrincipal().getName() + " does not have access to the comments of document " + parentId);
        }
        return (Comment)commentModel.getAdapter(Comment.class);
    }

    public Comment updateExternalComment(CoreSession session, String entityId, Comment comment) throws CommentNotFoundException {
        DocumentModel commentModel = this.getExternalCommentModel(session, entityId);
        if (commentModel == null) {
            throw new CommentNotFoundException("The external comment " + entityId + " does not exist.");
        }
        NuxeoPrincipal principal = session.getPrincipal();
        if (!principal.isAdministrator() && !comment.getAuthor().equals(principal.getName())) {
            throw new CommentSecurityException("The user " + principal.getName() + " can not edit comments of document " + comment.getParentId());
        }
        return (Comment)CoreInstance.doPrivileged((CoreSession)session, s -> {
            DocumentModelJsonReader.applyDirtyPropertyValues((DocumentModel)comment.getDocument(), (DocumentModel)commentModel);
            s.saveDocument(commentModel);
            this.notifyEvent((CoreSession)s, "commentUpdated", commentModel);
            return (Comment)commentModel.getAdapter(Comment.class);
        });
    }

    public void deleteExternalComment(CoreSession session, String entityId) throws CommentNotFoundException {
        DocumentModel commentModel = this.getExternalCommentModel(session, entityId);
        if (commentModel == null) {
            throw new CommentNotFoundException("The external comment " + entityId + " does not exist.");
        }
        NuxeoPrincipal principal = session.getPrincipal();
        String parentId = (String)((Object)commentModel.getPropertyValue("comment:parentId"));
        if (!(principal.isAdministrator() || commentModel.getPropertyValue("comment:author").equals(principal.getName()) || session.hasPermission(principal, this.getTopLevelDocumentRef(session, commentModel.getRef()), "Everything"))) {
            throw new CommentSecurityException("The user " + principal.getName() + " can not delete comments of document " + parentId);
        }
        CoreInstance.doPrivileged((CoreSession)session, s -> {
            DocumentModel comment = s.getDocument(commentModel.getRef());
            comment.detach(true);
            s.removeDocument(commentModel.getRef());
            this.notifyEvent((CoreSession)s, "commentRemoved", comment);
        });
    }

    public boolean hasFeature(CommentManager.Feature feature) {
        switch (feature) {
            case COMMENTS_LINKED_WITH_PROPERTY: {
                return true;
            }
        }
        throw new UnsupportedOperationException(feature.name());
    }

    @Override
    protected DocumentModel getTopLevelDocument(CoreSession s, DocumentModel commentDoc) {
        DocumentRef ancestorRef = this.getAncestorRef(s, commentDoc);
        return s.getDocument(ancestorRef);
    }

    protected DocumentModel getExternalCommentModel(CoreSession session, String entityId) {
        PageProviderService ppService = (PageProviderService)Framework.getService(PageProviderService.class);
        Map<String, Serializable> props = Collections.singletonMap("coreSession", (Serializable)session);
        List results = ppService.getPageProvider(GET_COMMENT_PAGEPROVIDER_NAME, null, Long.valueOf(1L), Long.valueOf(0L), props, new Object[]{entityId}).getCurrentPage();
        if (results.isEmpty()) {
            return null;
        }
        return (DocumentModel)results.get(0);
    }

    protected String getCommentContainerPath(CoreSession session, String commentedDocumentId) {
        return (String)CoreInstance.doPrivileged((CoreSession)session, s -> {
            DocumentModel annotatedDoc = s.getDocument((DocumentRef)new IdRef(commentedDocumentId));
            Object parentPath = "/";
            if (annotatedDoc.getPath().segmentCount() > 1) {
                parentPath = (String)parentPath + annotatedDoc.getPath().segment(0);
            }
            PathRef ref = new PathRef((String)parentPath, "Comments");
            DocumentModel commentFolderDoc = s.createDocumentModel((String)parentPath, "Comments", HIDDEN_FOLDER_TYPE);
            commentFolderDoc.putContextData("disableNotificationService", (Serializable)Boolean.valueOf(true));
            s.getOrCreateDocument(commentFolderDoc);
            s.save();
            return ref.toString();
        });
    }

    protected DocumentRef getAncestorRef(CoreSession session, DocumentModel documentModel) {
        if (!documentModel.hasSchema(COMMENT_NAME)) {
            return documentModel.getRef();
        }
        DocumentModel thread = this.getThreadForComment(session, documentModel);
        return new IdRef((String)((Object)thread.getPropertyValue("comment:parentId")));
    }

    protected DocumentModel getThreadForComment(CoreSession s, DocumentModel comment) throws CommentSecurityException {
        NuxeoPrincipal principal = s.getPrincipal();
        return (DocumentModel)CoreInstance.doPrivileged((CoreSession)s, session -> {
            DocumentRef ancestorRef;
            DocumentModel thread = comment;
            DocumentModel parent = s.getDocument((DocumentRef)new IdRef((String)((Object)thread.getPropertyValue("comment:parentId"))));
            if (parent.hasSchema(COMMENT_NAME)) {
                thread = this.getThreadForComment(parent);
            }
            if (!s.hasPermission(principal, ancestorRef = s.getDocument((DocumentRef)new IdRef((String)((Object)thread.getPropertyValue("comment:parentId")))).getRef(), "Read")) {
                throw new CommentSecurityException("The user " + principal.getName() + " does not have access to the comments of document " + ancestorRef.reference());
            }
            return thread;
        });
    }

    @Override
    protected DocumentModel getCommentedDocument(CoreSession session, DocumentModel commentDoc) {
        String parentId = (String)((Object)commentDoc.getPropertyValue("comment:parentId"));
        return session.getDocument((DocumentRef)new IdRef(parentId));
    }

    private /* synthetic */ PartialList lambda$getComments$9(DocumentRef docRef, NuxeoPrincipal principal, String documentId, PageProviderService ppService, boolean sortAscending, Long pageSize, Long currentPageIndex, CoreSession s) {
        DocumentRef ancestorRef;
        if (s.exists(docRef) && s.exists(ancestorRef = this.getTopLevelDocumentRef(s, docRef)) && !s.hasPermission(principal, ancestorRef, "Read")) {
            throw new CommentSecurityException("The user " + principal.getName() + " does not have access to the comments of document " + documentId);
        }
        Map<String, Serializable> props = Collections.singletonMap("coreSession", (Serializable)s);
        PageProvider pageProvider = ppService.getPageProvider(GET_COMMENTS_FOR_DOC_PAGEPROVIDER_NAME, Collections.singletonList(new SortInfo("comment:creationDate", sortAscending)), pageSize, currentPageIndex, props, new Object[]{documentId});
        List commentList = pageProvider.getCurrentPage();
        return commentList.stream().map(doc -> (Comment)doc.getAdapter(Comment.class)).collect(Collectors.collectingAndThen(Collectors.toList(), list -> new PartialList(list, pageProvider.getResultsCount())));
    }

    private /* synthetic */ Comment lambda$getComment$6(DocumentRef commentRef, NuxeoPrincipal principal, CoreSession s) {
        DocumentModel commentModel = s.getDocument(commentRef);
        DocumentRef documentRef = this.getTopLevelDocumentRef(s, commentModel.getRef());
        if (!s.hasPermission(principal, documentRef, "Read")) {
            throw new CommentSecurityException("The user " + principal.getName() + " does not have access to the comments of document " + documentRef.reference());
        }
        return (Comment)commentModel.getAdapter(Comment.class);
    }

    private static /* synthetic */ Boolean lambda$getComment$5(DocumentRef commentRef, CoreSession s) {
        return s.exists(commentRef);
    }

    private /* synthetic */ DocumentRef lambda$createComment$3(DocumentRef parentRef, CoreSession s) {
        DocumentModel parentDocModel = s.getDocument(parentRef);
        if (parentDocModel.hasSchema(COMMENT_NAME)) {
            return this.getAncestorRef(s, parentDocModel);
        }
        return parentDocModel.getRef();
    }

    private static /* synthetic */ Boolean lambda$createComment$2(DocumentRef parentRef, CoreSession s) {
        return s.exists(parentRef);
    }
}

