/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.management.jtajca.internal;

import io.dropwizard.metrics5.Metric;
import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.SharedMetricRegistries;
import io.dropwizard.metrics5.jvm.JmxAttributeGauge;
import org.nuxeo.ecm.core.management.jtajca.ConnectionPoolMonitor;
import org.nuxeo.ecm.core.management.jtajca.internal.DefaultMonitorComponent;
import org.nuxeo.runtime.jtajca.NuxeoConnectionManager;
import org.nuxeo.runtime.jtajca.NuxeoContainer;
import org.nuxeo.runtime.metrics.MetricsService;

public class DefaultConnectionPoolMonitor
implements ConnectionPoolMonitor {
    protected final MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    protected final String name;
    protected NuxeoConnectionManager cm;
    protected MetricName countGauge;
    protected MetricName idleGauge;
    protected MetricName killedGauge;
    protected DefaultMonitorComponent.ServerInstance self;

    protected DefaultConnectionPoolMonitor(String mame, NuxeoConnectionManager cm) {
        this.name = mame;
        this.cm = cm;
    }

    public NuxeoConnectionManager getManager() {
        return this.cm;
    }

    @Override
    public void install() {
        this.self = DefaultMonitorComponent.bind(this, this.name);
        this.countGauge = MetricName.build((String[])new String[]{"nuxeo", "repositories", "repository", "connection", "count"}).tagged(new String[]{"repository", this.name});
        this.idleGauge = MetricName.build((String[])new String[]{"nuxeo", "repositories", "repository", "connection", "idle"}).tagged(new String[]{"repository", this.name});
        this.killedGauge = MetricName.build((String[])new String[]{"nuxeo", "repositories", "repository", "connection", "killed"}).tagged(new String[]{"repository", this.name});
        this.registry.register(this.countGauge, (Metric)new JmxAttributeGauge(this.self.name, "ConnectionCount"));
        this.registry.register(this.idleGauge, (Metric)new JmxAttributeGauge(this.self.name, "IdleConnectionCount"));
        this.registry.register(this.killedGauge, (Metric)new JmxAttributeGauge(this.self.name, "KilledActiveConnectionCount"));
    }

    @Override
    public void uninstall() {
        DefaultMonitorComponent.unbind(this.self);
        this.registry.remove(this.countGauge);
        this.registry.remove(this.idleGauge);
        this.registry.remove(this.killedGauge);
        this.self = null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getConnectionCount() {
        return this.cm.getConnectionCount();
    }

    public int getIdleConnectionCount() {
        return this.cm.getIdleConnectionCount();
    }

    public int getBlockingTimeoutMilliseconds() {
        return this.cm.getBlockingTimeoutMilliseconds();
    }

    public int getIdleTimeoutMinutes() {
        return this.cm.getIdleTimeoutMinutes();
    }

    @Override
    public int getActiveTimeoutMinutes() {
        return this.cm.getActiveTimeoutMinutes();
    }

    public int getPartitionCount() {
        return this.cm.getPartitionCount();
    }

    public int getPartitionMaxSize() {
        return this.cm.getPartitionMaxSize();
    }

    public void setPartitionMaxSize(int maxSize) throws InterruptedException {
        this.cm.setPartitionMaxSize(maxSize);
    }

    public int getPartitionMinSize() {
        return this.cm.getPartitionMinSize();
    }

    public void setPartitionMinSize(int minSize) {
        this.cm.setPartitionMinSize(minSize);
    }

    public void setBlockingTimeoutMilliseconds(int timeoutMilliseconds) {
        this.cm.setBlockingTimeoutMilliseconds(timeoutMilliseconds);
    }

    public void setIdleTimeoutMinutes(int idleTimeoutMinutes) {
        this.cm.setIdleTimeoutMinutes(idleTimeoutMinutes);
    }

    public void handleNewConnectionManager(NuxeoConnectionManager cm) {
        this.cm = cm;
    }

    @Override
    public void reset() {
        NuxeoContainer.resetConnectionManager((String)this.name);
    }

    @Override
    public long getKilledActiveConnectionCount() {
        return this.cm.getKilledConnectionCount();
    }

    @Override
    public int killActiveTimedoutConnections() {
        return this.cm.killActiveTimedoutConnections(System.currentTimeMillis()).size();
    }
}

