/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.suggestbox.service.suggesters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.platform.suggestbox.service.GroupSuggestion;
import org.nuxeo.ecm.platform.suggestbox.service.Suggester;
import org.nuxeo.ecm.platform.suggestbox.service.Suggestion;
import org.nuxeo.ecm.platform.suggestbox.service.SuggestionContext;
import org.nuxeo.ecm.platform.suggestbox.service.SuggestionException;
import org.nuxeo.ecm.platform.suggestbox.service.UserSuggestion;
import org.nuxeo.ecm.platform.suggestbox.service.descriptors.SuggesterDescriptor;
import org.nuxeo.ecm.platform.suggestbox.service.suggesters.I18nHelper;
import org.nuxeo.ecm.platform.usermanager.UserAdapter;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class UserGroupLookupSuggester
implements Suggester {
    protected String userIconURL = "/icons/user.png";
    protected String groupIconURL = "/icons/group.png";
    protected String searchIconURL = "/img/facetedSearch.png";
    protected SuggesterDescriptor descriptor;
    protected List<String> searchFields = new ArrayList<String>();
    protected final String searchLabelPrefix = "label.searchDocumentsByUser_";
    protected int userSuggestionsLimit = 5;
    protected int groupSuggestionsLimit = 5;
    protected String suggesterId = "UserGroupLookupSuggester";

    @Override
    public List<Suggestion> suggest(String userInput, SuggestionContext context) throws SuggestionException {
        I18nHelper.instanceFor(context.messages);
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        ArrayList<Suggestion> suggestions = new ArrayList<Suggestion>();
        ArrayList searchSuggestions = new ArrayList();
        try {
            int count = 0;
            for (DocumentModel userDoc : userManager.searchUsers(userInput)) {
                UserAdapter user = (UserAdapter)userDoc.getAdapter(UserAdapter.class);
                String firstName = user.getFirstName();
                Object userLabel = firstName != null ? firstName : "";
                String lastName = user.getLastName();
                userLabel = (String)userLabel + " ";
                userLabel = (String)userLabel + (lastName != null ? lastName : "");
                if (((String)(userLabel = ((String)userLabel).trim())).isEmpty()) {
                    userLabel = user.getName();
                }
                suggestions.add(new UserSuggestion(userDoc.getId(), (String)userLabel, this.userIconURL));
                if (++count < this.userSuggestionsLimit) continue;
                break;
            }
            count = 0;
            String groupIdField = userManager.getGroupIdField();
            String groupLabelField = userManager.getGroupLabelField();
            for (DocumentModel group : userManager.searchGroups(userInput)) {
                String label = (String)group.getProperty(groupLabelField).getValue(String.class);
                if (label == null || label.isEmpty()) {
                    label = (String)group.getProperty(groupIdField).getValue(String.class);
                }
                suggestions.add(new GroupSuggestion(group.getId(), label, this.groupIconURL));
                if (++count < this.groupSuggestionsLimit) continue;
                break;
            }
            suggestions.addAll(searchSuggestions);
            return suggestions;
        }
        catch (DirectoryException e) {
            throw new SuggestionException(String.format("Suggester '%s' failed to perform query with input '%s'", this.descriptor.getName(), userInput), e);
        }
    }

    @Override
    public void initWithParameters(SuggesterDescriptor descriptor) {
        String searchFields;
        String groupSuggestionsLimit;
        String userSuggestionsLimit;
        String searchIconURL;
        String groupIconURL;
        Map<String, String> params = descriptor.getParameters();
        String userIconURL = params.get("userIconURL");
        if (userIconURL != null) {
            this.userIconURL = userIconURL;
        }
        if ((groupIconURL = params.get("groupIconURL")) != null) {
            this.groupIconURL = groupIconURL;
        }
        if ((searchIconURL = params.get("searchIconURL")) != null) {
            this.searchIconURL = searchIconURL;
        }
        if ((userSuggestionsLimit = params.get("userSuggestionsLimit")) != null) {
            this.userSuggestionsLimit = Integer.valueOf(userSuggestionsLimit);
        }
        if ((groupSuggestionsLimit = params.get("groupSuggestionsLimit")) != null) {
            this.groupSuggestionsLimit = Integer.valueOf(groupSuggestionsLimit);
        }
        if ((searchFields = params.get("searchFields")) != null && !searchFields.isEmpty()) {
            this.searchFields = Arrays.asList(searchFields.split(", *"));
        }
        this.descriptor = descriptor;
    }
}

