/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.directory;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="directory")
public class DirectoryRootObject
extends DefaultObject {
    @Path(value="{directoryName}")
    public Object doGetDirectory(@PathParam(value="directoryName") String dirName) {
        return this.newObject("directoryObject", new Object[]{dirName});
    }

    @GET
    public List<Directory> getDirectoryNames(@QueryParam(value="types") List<String> types) {
        DirectoryService directoryService = (DirectoryService)Framework.getService(DirectoryService.class);
        ArrayList<Directory> result = new ArrayList<Directory>();
        for (Directory dir : directoryService.getDirectories()) {
            if (dir.getTypes().contains("system")) continue;
            if (types == null || types.isEmpty()) {
                result.add(dir);
                continue;
            }
            if (!types.stream().filter(dir.getTypes()::contains).findFirst().isPresent()) continue;
            result.add(dir);
        }
        return result;
    }
}

