/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.users;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.usermanager.UserManager;

@Operation(id="User.Query", category="Users & Groups", aliases={"Services.QueryUsers"}, label="Query users", description="Query users on a combination of their username, firstName and lastName fields, or on any of them (pattern).")
public class QueryUsers {
    public static final String ID = "User.Query";
    public static final Set<String> FULLTEXT_FIELDS = new HashSet<String>(Arrays.asList("username", "firstName", "lastName"));
    public static final String JSON_USERNAME = "username";
    public static final String JSON_FIRSTNAME = "firstName";
    public static final String JSON_LASTNAME = "lastName";
    public static final String JSON_EMAIL = "email";
    public static final String JSON_COMPANY = "company";
    public static final String JSON_TENANT_ID = "tenantId";
    @Context
    protected UserManager userManager;
    @Param(name="username", required=false)
    protected String username;
    @Param(name="firstName", required=false)
    protected String firstName;
    @Param(name="lastName", required=false)
    protected String lastName;
    @Param(name="pattern", required=false)
    protected String pattern;
    @Param(name="tenantId", required=false)
    protected String tenantId;

    @OperationMethod
    public Blob run() throws IOException {
        DocumentModelList users;
        if (StringUtils.isBlank((CharSequence)this.pattern)) {
            HashMap<String, String> filter = new HashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)this.username)) {
                filter.put(JSON_USERNAME, this.username);
            }
            if (StringUtils.isNotBlank((CharSequence)this.firstName)) {
                filter.put(JSON_FIRSTNAME, this.firstName);
            }
            if (StringUtils.isNotBlank((CharSequence)this.lastName)) {
                filter.put(JSON_LASTNAME, this.lastName);
            }
            if (StringUtils.isNotBlank((CharSequence)this.tenantId)) {
                filter.put(JSON_TENANT_ID, this.tenantId);
            }
            users = this.userManager.searchUsers(filter, FULLTEXT_FIELDS);
        } else {
            users = new ArrayList();
            HashSet<String> userIds = new HashSet<String>();
            for (String field : FULLTEXT_FIELDS) {
                HashMap<String, String> filter = new HashMap<String, String>();
                filter.put(field, this.pattern);
                if (StringUtils.isNotBlank((CharSequence)this.tenantId)) {
                    filter.put(JSON_TENANT_ID, this.tenantId);
                }
                DocumentModelList userDocs = this.userManager.searchUsers(filter, Collections.singleton(field));
                for (DocumentModel userDoc : userDocs) {
                    if (!userIds.add(userDoc.getId())) continue;
                    users.add(userDoc);
                }
            }
        }
        return this.buildResponse((List<DocumentModel>)users);
    }

    protected Blob buildResponse(List<DocumentModel> users) throws IOException {
        ArrayList<LinkedHashMap<String, Object>> array = new ArrayList<LinkedHashMap<String, Object>>();
        for (DocumentModel user : users) {
            LinkedHashMap<String, Object> o = new LinkedHashMap<String, Object>();
            this.putIfNotNull(o, JSON_USERNAME, user.getProperty("user", JSON_USERNAME));
            this.putIfNotNull(o, JSON_FIRSTNAME, user.getProperty("user", JSON_FIRSTNAME));
            this.putIfNotNull(o, JSON_LASTNAME, user.getProperty("user", JSON_LASTNAME));
            this.putIfNotNull(o, JSON_EMAIL, user.getProperty("user", JSON_EMAIL));
            this.putIfNotNull(o, JSON_COMPANY, user.getProperty("user", JSON_COMPANY));
            this.putIfNotNull(o, JSON_TENANT_ID, user.getProperty("user", JSON_TENANT_ID));
            array.add(o);
        }
        return Blobs.createJSONBlobFromValue(Collections.singletonMap("users", array));
    }

    protected void putIfNotNull(Map<String, Object> map, String key, Object value) {
        if (value != null) {
            map.put(key, value);
        }
    }
}

