/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.repository.FulltextConfiguration;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.TypeConstants;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.SimpleTypeImpl;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.BinaryType;
import org.nuxeo.ecm.core.schema.types.primitives.StringType;
import org.nuxeo.ecm.core.storage.FulltextDescriptor;
import org.nuxeo.runtime.api.Framework;

public class FulltextConfigurationFactory {
    private static final Log log = LogFactory.getLog(FulltextConfigurationFactory.class);
    public static final String PROP_TYPE_STRING = "string";
    public static final String PROP_TYPE_BLOB = "blob";
    public static final String FULLTEXT_DEFAULT_INDEX = "default";

    public static FulltextConfiguration make(FulltextDescriptor fulltextDescriptor) {
        SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        FulltextConfiguration ftc = new FulltextConfiguration();
        ftc.fulltextFieldSizeLimit = fulltextDescriptor.getFulltextFieldSizeLimit();
        ftc.fulltextStoredInBlob = fulltextDescriptor.getFulltextStoredInBlob();
        ftc.fulltextSearchDisabled = fulltextDescriptor.getFulltextSearchDisabled();
        HashSet<String> allSimplePaths = new HashSet<String>();
        HashSet<String> allBinaryPaths = new HashSet<String>();
        PathsFinder pathsFinder = new PathsFinder(allSimplePaths, allBinaryPaths);
        for (Schema schema : schemaManager.getSchemas()) {
            pathsFinder.walkSchema(schema);
        }
        List<FulltextDescriptor.FulltextIndexDescriptor> descs = fulltextDescriptor.getFulltextIndexes();
        if (descs == null) {
            descs = new ArrayList<FulltextDescriptor.FulltextIndexDescriptor>(1);
        }
        if (descs.isEmpty()) {
            descs.add(new FulltextDescriptor.FulltextIndexDescriptor());
        }
        for (FulltextDescriptor.FulltextIndexDescriptor desc : descs) {
            String name = desc.name == null ? FULLTEXT_DEFAULT_INDEX : desc.name;
            ftc.indexNames.add(name);
            if (desc.fields == null) {
                desc.fields = new HashSet<String>();
            }
            if (desc.excludeFields == null) {
                desc.excludeFields = new HashSet<String>();
            }
            if (desc.fields.size() == 1 && desc.excludeFields.isEmpty()) {
                ftc.fieldToIndexName.put(desc.fields.iterator().next(), name);
            }
            if (desc.fieldType != null) {
                if (desc.fieldType.equals(PROP_TYPE_STRING)) {
                    ftc.indexesAllSimple.add(name);
                } else if (desc.fieldType.equals(PROP_TYPE_BLOB)) {
                    ftc.indexesAllBinary.add(name);
                } else {
                    log.error((Object)("Ignoring unknow repository fulltext configuration fieldType: " + desc.fieldType));
                }
            }
            if (desc.fields.isEmpty() && desc.fieldType == null) {
                ftc.indexesAllSimple.add(name);
                ftc.indexesAllBinary.add(name);
            }
            if (ftc.indexesAllSimple.contains(name)) {
                ftc.propPathsByIndexSimple.put(name, new HashSet<String>(allSimplePaths));
                for (String path : allSimplePaths) {
                    ftc.indexesByPropPathSimple.computeIfAbsent(path, p -> new HashSet()).add(name);
                }
            }
            if (ftc.indexesAllBinary.contains(name)) {
                ftc.propPathsByIndexBinary.put(name, new HashSet<String>(allBinaryPaths));
                for (String path : allBinaryPaths) {
                    ftc.indexesByPropPathBinary.computeIfAbsent(path, p -> new HashSet()).add(name);
                }
            }
            if (fulltextDescriptor.getFulltextExcludedTypes() != null) {
                ftc.excludedTypes.addAll(fulltextDescriptor.getFulltextExcludedTypes());
            }
            if (fulltextDescriptor.getFulltextIncludedTypes() != null) {
                ftc.includedTypes.addAll(fulltextDescriptor.getFulltextIncludedTypes());
            }
            for (Set fields : Arrays.asList(desc.fields, desc.excludeFields)) {
                boolean include = fields == desc.fields;
                for (Object path : fields) {
                    Map propPathsByIndex;
                    Map indexesByPropPath;
                    Field field = schemaManager.getField((String)path);
                    if (field == null && !((String)path).contains(":")) {
                        int slash = ((String)path).indexOf(47);
                        String first = slash == -1 ? path : ((String)path).substring(0, slash);
                        for (Schema schema : schemaManager.getSchemas()) {
                            if (schema.getNamespace().hasPrefix() || schema.getField(first) == null) continue;
                            path = schema.getName() + ":" + (String)path;
                            field = schemaManager.getField((String)path);
                            break;
                        }
                    }
                    if (field == null) {
                        log.error((Object)String.format("Ignoring unknown property '%s' in fulltext configuration: %s", path, name));
                        continue;
                    }
                    Type baseType = FulltextConfigurationFactory.getBaseType(field.getType());
                    if (baseType instanceof ComplexType && TypeConstants.isContentType((Type)baseType)) {
                        baseType = ((ComplexType)baseType).getField("data").getType();
                    }
                    if (baseType instanceof StringType) {
                        indexesByPropPath = include ? ftc.indexesByPropPathSimple : ftc.indexesByPropPathExcludedSimple;
                        propPathsByIndex = include ? ftc.propPathsByIndexSimple : ftc.propPathsExcludedByIndexSimple;
                    } else if (baseType instanceof BinaryType) {
                        indexesByPropPath = include ? ftc.indexesByPropPathBinary : ftc.indexesByPropPathExcludedBinary;
                        Map map = propPathsByIndex = include ? ftc.propPathsByIndexBinary : ftc.propPathsExcludedByIndexBinary;
                        if (!((String)path).endsWith("/data")) {
                            path = (String)path + "/data";
                        }
                    } else {
                        log.error((Object)String.format("Ignoring property '%s' with bad type %s in fulltext configuration: %s", path, field.getType(), name));
                        continue;
                    }
                    indexesByPropPath.computeIfAbsent(path, p -> new HashSet()).add(name);
                    propPathsByIndex.computeIfAbsent(name, n -> new HashSet()).add(path);
                }
            }
        }
        for (DocumentType documentType : schemaManager.getDocumentTypes()) {
            if (!documentType.hasFacet("NotFulltextIndexable")) continue;
            ftc.excludedTypes.add(documentType.getName());
        }
        return ftc;
    }

    protected static Type getBaseType(Type type) {
        if (type instanceof SimpleTypeImpl) {
            return FulltextConfigurationFactory.getBaseType(type.getSuperType());
        }
        if (type instanceof ListType) {
            return FulltextConfigurationFactory.getBaseType(((ListType)type).getFieldType());
        }
        return type;
    }

    public static class PathsFinder {
        protected final Set<String> simplePaths;
        protected final Set<String> binaryPaths;

        public PathsFinder(Set<String> simplePaths, Set<String> binaryPaths) {
            this.simplePaths = simplePaths;
            this.binaryPaths = binaryPaths;
        }

        public void walkSchema(Schema schema) {
            String addPrefix = schema.getNamespace().hasPrefix() ? null : schema.getName();
            this.walkComplexType((ComplexType)schema, null, addPrefix);
        }

        protected void walkComplexType(ComplexType complexType, String path, String addPrefix) {
            for (Field field : complexType.getFields()) {
                String name = field.getName().getPrefixedName();
                String fieldPath = path == null ? name : path + "/" + name;
                this.walkType(field.getType(), fieldPath, addPrefix);
            }
        }

        protected void walkType(Type type, String path, String addPrefix) {
            if (type.isSimpleType()) {
                this.walkSimpleType(type, path, addPrefix);
            } else if (type.isListType()) {
                String listPath = path + "/*";
                Type ftype = ((ListType)type).getField().getType();
                if (ftype.isComplexType()) {
                    this.walkComplexType((ComplexType)ftype, listPath, addPrefix);
                } else {
                    this.walkSimpleType(ftype, listPath, addPrefix);
                }
            } else {
                ComplexType ctype = (ComplexType)type;
                this.walkComplexType(ctype, path, addPrefix);
            }
        }

        protected void walkSimpleType(Type type, String path, String addPrefix) {
            while (type instanceof SimpleTypeImpl) {
                type = type.getSuperType();
            }
            if (type instanceof StringType) {
                this.simplePaths.add(path);
                if (addPrefix != null) {
                    this.simplePaths.add(addPrefix + ":" + path);
                }
            } else if (type instanceof BinaryType) {
                this.binaryPaths.add(path);
                if (addPrefix != null) {
                    this.binaryPaths.add(addPrefix + ":" + path);
                }
            }
        }
    }
}

