/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.Pair;

public class BatchUtils {
    private BatchUtils() {
    }

    public static <T, U> List<Pair<U, List<T>>> groupByDerived(List<T> values, Function<T, U> deriver, BiPredicate<U, U> comparator) {
        ArrayList<Pair<U, List<T>>> result = new ArrayList<Pair<U, List<T>>>();
        Object previousDerived = null;
        ArrayList<T> batch = null;
        for (T value : values) {
            U derived = deriver.apply(value);
            if (batch == null || !comparator.test(derived, previousDerived)) {
                batch = new ArrayList<T>();
                result.add(Pair.of(derived, batch));
            }
            batch.add(value);
            previousDerived = derived;
        }
        return result;
    }
}

