/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.url;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.platform.types.adapter.TypeInfo;
import org.nuxeo.ecm.platform.url.api.DocumentView;

public class DocumentViewImpl
implements DocumentView,
Serializable {
    private static final long serialVersionUID = 1L;
    private DocumentLocation documentLocation;
    private String viewId;
    private String subURI;
    private String patternName;
    private Map<String, String> parameters;

    public DocumentViewImpl(DocumentLocation documentLocation, String viewId) {
        this.documentLocation = documentLocation;
        this.viewId = viewId;
    }

    public DocumentViewImpl(DocumentLocation documentLocation, String viewId, Map<String, String> parameters) {
        this.documentLocation = documentLocation;
        this.viewId = viewId;
        this.parameters = parameters;
    }

    public DocumentViewImpl(DocumentLocation documentLocation, String viewId, String subURI, Map<String, String> parameters) {
        this.documentLocation = documentLocation;
        this.viewId = viewId;
        this.subURI = subURI;
        this.parameters = parameters;
    }

    public DocumentViewImpl(DocumentModel doc) {
        this.documentLocation = new DocumentLocationImpl(doc);
        TypeInfo typeInfo = (TypeInfo)doc.getAdapter(TypeInfo.class);
        this.viewId = typeInfo.getDefaultView();
    }

    public DocumentViewImpl(DocumentLocation docLoc) {
        this.documentLocation = docLoc;
        this.subURI = null;
    }

    @Override
    public DocumentLocation getDocumentLocation() {
        return this.documentLocation;
    }

    public String getTabId() {
        if (this.parameters != null) {
            return this.parameters.get("tabId");
        }
        return null;
    }

    @Override
    public String getViewId() {
        if (this.viewId == null && this.parameters != null) {
            return this.parameters.get("viewId");
        }
        return this.viewId;
    }

    @Override
    public String getSubURI() {
        return this.subURI;
    }

    @Override
    public Map<String, String> getParameters() {
        String tabId;
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        if ((tabId = this.getTabId()) != null) {
            this.parameters.put("tabId", tabId);
        }
        return Collections.unmodifiableMap(this.parameters);
    }

    @Override
    public String getParameter(String name) {
        if (this.parameters == null) {
            return null;
        }
        return this.parameters.get(name);
    }

    @Override
    public void addParameter(String name, String value) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        this.parameters.put(name, value);
    }

    @Override
    public void removeParameter(String name) {
        if (this.parameters == null) {
            return;
        }
        this.parameters.remove(name);
    }

    @Override
    public void setDocumentLocation(DocumentLocation documentLocation) {
        this.documentLocation = documentLocation;
    }

    @Override
    public void setSubURI(String subURI) {
        this.subURI = subURI;
    }

    @Override
    public void setViewId(String viewId) {
        this.viewId = viewId;
    }

    @Override
    public String getPatternName() {
        return this.patternName;
    }

    @Override
    public void setPatternName(String patternName) {
        this.patternName = patternName;
    }

    public String toString() {
        return String.format("DocumentViewImpl [documentLocation=%s, parameters=%s, patternName=%s, subURI=%s, viewId=%s]", this.documentLocation, this.parameters, this.patternName, this.subURI, this.viewId);
    }
}

