/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.impl;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.io.DocumentReader;
import org.nuxeo.ecm.core.io.ExportedDocument;

public abstract class AbstractDocumentReader
implements DocumentReader {
    private static final Log log = LogFactory.getLog(AbstractDocumentReader.class);

    @Override
    public abstract ExportedDocument read() throws IOException;

    @Override
    public ExportedDocument[] read(int count) throws IOException {
        ExportedDocument doc;
        ArrayList<ExportedDocument> docs = new ArrayList<ExportedDocument>(count);
        for (int i = 0; i < count && (doc = this.read()) != null; ++i) {
            if (doc.getId() != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding document to be transformed (path): " + doc.getPath()));
                }
                docs.add(doc);
                continue;
            }
            log.warn((Object)("no ID for document, won't add " + doc));
        }
        if (docs.isEmpty()) {
            return null;
        }
        return docs.toArray(new ExportedDocument[docs.size()]);
    }
}

