/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.bulk.computation;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.scroll.Scroll;
import org.nuxeo.ecm.core.api.scroll.ScrollRequest;
import org.nuxeo.ecm.core.api.scroll.ScrollService;
import org.nuxeo.ecm.core.bulk.BulkAdminService;
import org.nuxeo.ecm.core.bulk.BulkAdminServiceImpl;
import org.nuxeo.ecm.core.bulk.BulkCodecs;
import org.nuxeo.ecm.core.bulk.BulkService;
import org.nuxeo.ecm.core.bulk.message.BulkBucket;
import org.nuxeo.ecm.core.bulk.message.BulkCommand;
import org.nuxeo.ecm.core.bulk.message.BulkStatus;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.scroll.DocumentScrollRequest;
import org.nuxeo.ecm.core.scroll.EmptyScrollRequest;
import org.nuxeo.ecm.core.scroll.GenericScrollRequest;
import org.nuxeo.lib.stream.computation.AbstractComputation;
import org.nuxeo.lib.stream.computation.ComputationContext;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.computation.internals.ComputationContextImpl;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;
import org.nuxeo.runtime.transaction.TransactionRuntimeException;

public class BulkScrollerComputation
extends AbstractComputation {
    private static final Logger log = LogManager.getLogger(BulkScrollerComputation.class);
    public static final int MAX_SCROLL_SIZE = 4000;
    protected final int scrollBatchSize;
    protected final int scrollKeepAliveSeconds;
    protected final List<String> documentIds;
    protected final boolean produceImmediate;
    protected final long produceImmediateThreshold;
    protected final int transactionTimeoutSeconds;
    protected int scrollSize;
    protected int bucketSize;
    protected String actionStream;

    public BulkScrollerComputation(String name, int nbOutputStreams, int scrollBatchSize, int scrollKeepAliveSeconds, boolean produceImmediate) {
        this(name, nbOutputStreams, scrollBatchSize, scrollKeepAliveSeconds, BulkAdminServiceImpl.DEFAULT_SCROLL_TRANSACTION_TIMEOUT, produceImmediate);
    }

    public BulkScrollerComputation(String name, int nbOutputStreams, int scrollBatchSize, int scrollKeepAliveSeconds, Duration transactionTimeout, boolean produceImmediate) {
        this(name, nbOutputStreams, scrollBatchSize, scrollKeepAliveSeconds, BulkAdminServiceImpl.DEFAULT_SCROLL_TRANSACTION_TIMEOUT, produceImmediate, 0);
    }

    public BulkScrollerComputation(String name, int nbOutputStreams, int scrollBatchSize, int scrollKeepAliveSeconds, Duration transactionTimeout, boolean produceImmediate, int produceImmediateThreshold) {
        super(name, 1, nbOutputStreams);
        this.scrollBatchSize = scrollBatchSize;
        this.scrollKeepAliveSeconds = scrollKeepAliveSeconds;
        this.produceImmediate = produceImmediate;
        this.produceImmediateThreshold = produceImmediateThreshold;
        this.transactionTimeoutSeconds = Math.toIntExact(transactionTimeout.toSeconds());
        this.documentIds = new ArrayList<String>(scrollBatchSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRecord(ComputationContext context, String inputStreamName, Record record) {
        boolean newTransaction = true;
        if (TransactionHelper.isTransactionActiveOrMarkedRollback()) {
            newTransaction = false;
            log.warn("Already inside a transaction, timeout cannot be applied, record: " + record, new Throwable("stack"));
        } else if (!TransactionHelper.startTransaction((int)this.transactionTimeoutSeconds)) {
            throw new TransactionRuntimeException("Cannot start transaction");
        }
        try {
            this.processRecord(context, record);
        }
        finally {
            if (newTransaction) {
                TransactionHelper.setTransactionRollbackOnly();
                TransactionHelper.commitOrRollbackTransaction();
            }
        }
    }

    protected void processRecord(ComputationContext context, Record record) {
        BulkCommand command = null;
        String commandId = null;
        try {
            command = (BulkCommand)BulkCodecs.getCommandCodec().decode(record.getData());
            commandId = command.getId();
            this.getCommandConfiguration(command);
            this.updateStatusAsScrolling(context, commandId);
            long documentCount = 0L;
            long bucketNumber = 1L;
            try (Scroll scroll = this.buildScroll(command);){
                while (scroll.hasNext()) {
                    if (this.isAbortedCommand(commandId)) {
                        log.debug("Skipping aborted command: {}", (Object)commandId);
                        context.askForCheckpoint();
                        return;
                    }
                    List docIds = (List)scroll.next();
                    this.documentIds.addAll(docIds);
                    while (this.documentIds.size() >= this.bucketSize) {
                        this.produceBucket(context, commandId, this.bucketSize, bucketNumber++, documentCount);
                    }
                    documentCount += (long)docIds.size();
                }
            }
            if (!this.documentIds.isEmpty()) {
                this.produceBucket(context, commandId, this.bucketSize, bucketNumber++, documentCount);
            }
            if (!command.useExternalScroller()) {
                this.updateStatusAfterScroll(context, commandId, documentCount);
            }
        }
        catch (IllegalArgumentException | DocumentNotFoundException | QueryParseException e) {
            log.error("Invalid query results in an empty document set: {}", (Object)command, (Object)e);
            this.updateStatusAfterScroll(context, commandId, "Invalid query");
        }
        catch (NuxeoException e) {
            if (command != null) {
                log.error("Invalid command produces an empty document set: {}", (Object)command, (Object)e);
                this.updateStatusAfterScroll(context, command.getId(), "Invalid command");
            }
            log.error("Discard invalid record: {}", (Object)record, (Object)e);
        }
        context.askForCheckpoint();
    }

    protected Scroll buildScroll(BulkCommand command) {
        Object request = command.useExternalScroller() ? EmptyScrollRequest.of() : (command.useGenericScroller() ? GenericScrollRequest.builder(command.getScroller(), command.getQuery()).options(command.getParams()).size(this.scrollSize).build() : DocumentScrollRequest.builder(command.getQuery()).username(command.getUsername()).repository(command.getRepository()).size(this.scrollSize).timeout(Duration.ofSeconds(this.scrollKeepAliveSeconds)).name(command.getScroller()).build());
        ScrollService service = (ScrollService)Framework.getService(ScrollService.class);
        return service.scroll((ScrollRequest)request);
    }

    protected void getCommandConfiguration(BulkCommand command) {
        BulkAdminService actionService = (BulkAdminService)Framework.getService(BulkAdminService.class);
        this.bucketSize = command.getBucketSize() > 0 ? command.getBucketSize() : actionService.getBucketSize(command.getAction());
        this.scrollSize = this.scrollBatchSize;
        if (this.bucketSize > this.scrollSize) {
            if (this.bucketSize <= 4000) {
                this.scrollSize = this.bucketSize;
            } else {
                log.warn("Bucket size: {} too big for command: {}, reduce to: {}", (Object)this.bucketSize, (Object)command, (Object)4000);
                this.bucketSize = 4000;
                this.scrollSize = 4000;
            }
        }
        this.actionStream = actionService.getInputStream(command.getAction());
    }

    protected boolean isAbortedCommand(String commandId) {
        BulkService bulkService = (BulkService)Framework.getService(BulkService.class);
        BulkStatus status = (BulkStatus)bulkService.getStatus((Serializable)((Object)commandId));
        return BulkStatus.State.ABORTED.equals((Object)status.getState());
    }

    protected void updateStatusAsScrolling(ComputationContext context, String commandId) {
        BulkStatus delta = BulkStatus.deltaOf(commandId);
        delta.setState(BulkStatus.State.SCROLLING_RUNNING);
        delta.setScrollStartTime(Instant.now());
        ((ComputationContextImpl)context).produceRecordImmediate("bulk/status", commandId, BulkCodecs.getStatusCodec().encode((Object)delta));
    }

    protected void updateStatusAfterScroll(ComputationContext context, String commandId, String errorMessage) {
        this.updateStatusAfterScroll(context, commandId, 0L, errorMessage);
    }

    protected void updateStatusAfterScroll(ComputationContext context, String commandId, long documentCount) {
        this.updateStatusAfterScroll(context, commandId, documentCount, null);
    }

    protected void updateStatusAfterScroll(ComputationContext context, String commandId, long documentCount, String errorMessage) {
        BulkStatus delta = BulkStatus.deltaOf(commandId);
        if (errorMessage != null) {
            delta.inError(errorMessage);
        }
        if (documentCount == 0L) {
            delta.setState(BulkStatus.State.COMPLETED);
            delta.setCompletedTime(Instant.now());
        } else {
            delta.setState(BulkStatus.State.RUNNING);
        }
        delta.setScrollEndTime(Instant.now());
        delta.setTotal(documentCount);
        ((ComputationContextImpl)context).produceRecordImmediate("bulk/status", commandId, BulkCodecs.getStatusCodec().encode((Object)delta));
    }

    protected void produceBucket(ComputationContext context, String commandId, int bucketSize, long bucketNumber, long documentCount) {
        List<String> ids = this.documentIds.subList(0, Math.min(bucketSize, this.documentIds.size()));
        BulkBucket bucket = new BulkBucket(commandId, ids);
        String key = commandId + ":" + Long.toString(bucketNumber);
        Record record = Record.of((String)key, (byte[])BulkCodecs.getBucketCodec().encode((Object)bucket));
        if (this.produceImmediate || this.produceImmediateThreshold > 0L && documentCount > this.produceImmediateThreshold) {
            ComputationContextImpl contextImpl = (ComputationContextImpl)context;
            if (!contextImpl.getRecords(this.actionStream).isEmpty()) {
                this.flushRecords(contextImpl, commandId);
            }
            contextImpl.produceRecordImmediate(this.actionStream, record);
        } else {
            context.produceRecord(this.actionStream, record);
        }
        ids.clear();
    }

    protected void flushRecords(ComputationContextImpl contextImpl, String commandId) {
        log.warn("Scroller records threshold reached ({}) for action: {} on command: {}, flushing records downstream", (Object)this.produceImmediateThreshold, (Object)this.actionStream, (Object)commandId);
        contextImpl.getRecords(this.actionStream).forEach(record -> contextImpl.produceRecordImmediate(this.actionStream, record));
        contextImpl.getRecords(this.actionStream).clear();
    }
}

