/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.scroll;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.nuxeo.ecm.core.api.scroll.ScrollRequest;

public class StaticScrollRequest
implements ScrollRequest {
    protected static final String SCROLL_TYPE = "static";
    protected static final String SCROLL_NAME = "list";
    protected final int size;
    protected final List<String> identifiers;

    protected StaticScrollRequest(Builder builder) {
        this.identifiers = builder.identifiers;
        this.size = builder.getSize();
    }

    public String getType() {
        return SCROLL_TYPE;
    }

    public String getName() {
        return SCROLL_NAME;
    }

    public int getSize() {
        return this.size;
    }

    public List<String> getIdentifiers() {
        return this.identifiers;
    }

    public static Builder builder(String singleIdentifier) {
        return new Builder(singleIdentifier);
    }

    public static Builder builder(List<String> identifiers) {
        return new Builder(identifiers);
    }

    public String toString() {
        return "StaticScrollRequest{size=" + this.size + ", identifiers=" + this.identifiers + "}";
    }

    public static class Builder {
        public static final int DEFAULT_SCROLL_SIZE = 10;
        protected final List<String> identifiers;
        protected int size;

        public Builder(String singleIdentifier) {
            Objects.requireNonNull(singleIdentifier, "identifier cannot be null");
            this.identifiers = Collections.singletonList(singleIdentifier);
        }

        public Builder(List<String> identifiers) {
            Objects.requireNonNull(identifiers, "identifiers cannot be null");
            List ids = identifiers.stream().map(String::trim).filter(Predicate.not(String::isBlank)).collect(Collectors.toList());
            if (ids.isEmpty()) {
                throw new IllegalArgumentException("identifiers cannot be empty");
            }
            this.identifiers = Collections.unmodifiableList(ids);
        }

        public Builder size(int size) {
            if (size <= 0) {
                throw new IllegalArgumentException("size must be > 0");
            }
            this.size = size;
            return this;
        }

        public int getSize() {
            return this.size == 0 ? 10 : this.size;
        }

        public StaticScrollRequest build() {
            return new StaticScrollRequest(this);
        }
    }
}

