/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.styling.service.palettes;

import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.theme.styling.service.palettes.PaletteParseException;
import org.nuxeo.theme.styling.service.palettes.PropertiesPaletteParser;

public class PaletteParser {
    private static final Log log = LogFactory.getLog(PaletteParser.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> parse(URL url) {
        HashMap<String, String> entries = new HashMap();
        InputStream in = null;
        try {
            in = url.openStream();
            entries = PaletteParser.parse(in, url.getFile());
            return entries;
        }
        catch (FileNotFoundException e) {
            log.error((Object)("File not found: " + url));
            return entries;
        }
        catch (IOException e) {
            log.error((Object)("Could not open file: " + url));
            return entries;
        }
        catch (PaletteParseException e) {
            log.error((Object)("Could not parse palette: " + url));
            return entries;
        }
        finally {
            if (in != null) {
                try {
                    try {
                        in.close();
                        in = null;
                    }
                    catch (IOException e) {
                        log.error((Object)e, (Throwable)e);
                        in = null;
                    }
                }
                catch (Throwable throwable) {
                    in = null;
                    throw throwable;
                }
            }
        }
    }

    public static boolean checkSanity(byte[] bytes) {
        return false;
    }

    public static String rgbToHex(int r, int g, int b) {
        int[] rgb;
        StringBuffer hexcolor = new StringBuffer("#");
        for (int val : rgb = new int[]{r, g, b}) {
            if (val < 16) {
                hexcolor.append("0");
            }
            hexcolor.append(Integer.toHexString(val));
        }
        if (hexcolor.charAt(1) == hexcolor.charAt(2) && hexcolor.charAt(3) == hexcolor.charAt(4) && hexcolor.charAt(5) == hexcolor.charAt(6)) {
            return "#" + hexcolor.charAt(1) + hexcolor.charAt(4) + hexcolor.charAt(6);
        }
        return hexcolor.toString();
    }

    public static Map<String, String> parse(InputStream in, String filename) throws IOException, PaletteParseException {
        byte[] bytes = IOUtils.toByteArray((InputStream)new DataInputStream(in));
        return PaletteParser.parse(bytes, filename);
    }

    public static Map<String, String> parse(byte[] bytes, String filename) throws PaletteParseException {
        return PropertiesPaletteParser.parse(bytes);
    }
}

