/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.computation.log;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.computation.RecordFilter;
import org.nuxeo.lib.stream.computation.RecordFilterChain;
import org.nuxeo.lib.stream.computation.Settings;
import org.nuxeo.lib.stream.computation.StreamManager;
import org.nuxeo.lib.stream.computation.StreamProcessor;
import org.nuxeo.lib.stream.computation.Topology;
import org.nuxeo.lib.stream.computation.log.LogStreamProcessor;
import org.nuxeo.lib.stream.log.LogManager;
import org.nuxeo.lib.stream.log.LogOffset;
import org.nuxeo.lib.stream.log.LogPartition;
import org.nuxeo.lib.stream.log.LogTailer;
import org.nuxeo.lib.stream.log.Name;
import org.nuxeo.lib.stream.log.RebalanceListener;
import org.nuxeo.lib.stream.log.internals.LogOffsetImpl;

public class LogStreamManager
implements StreamManager {
    private static final Log log = LogFactory.getLog(LogStreamManager.class);
    protected final LogManager logManager;
    protected final Map<String, Topology> topologies = new HashMap<String, Topology>();
    protected final Map<String, Settings> settings = new HashMap<String, Settings>();
    protected final Map<Name, RecordFilterChain> filters = new HashMap<Name, RecordFilterChain>();
    protected final Set<Name> streams = new HashSet<Name>();

    public LogStreamManager(LogManager logManager) {
        this.logManager = logManager;
    }

    @Override
    public void register(String processorName, Topology topology, Settings settings) {
        log.debug((Object)("Register processor: " + processorName));
        this.topologies.put(processorName, topology);
        this.settings.put(processorName, settings);
        this.initStreams(topology, settings);
        this.initAppenders(topology.streamsSet(), settings);
        this.registerFilters(topology.streamsSet(), settings);
    }

    @Override
    public void register(List<String> streams, Settings settings) {
        streams.forEach(stream -> this.initStream((String)stream, settings));
        this.initAppenders(streams, settings);
        this.registerFilters(streams, settings);
    }

    @Override
    public StreamProcessor createStreamProcessor(String processorName) {
        if (!this.topologies.containsKey(processorName)) {
            throw new IllegalArgumentException("Unregistered processor name: " + processorName);
        }
        LogStreamProcessor processor = new LogStreamProcessor(this);
        processor.init(this.topologies.get(processorName), this.settings.get(processorName));
        return processor;
    }

    public LogManager getLogManager() {
        return this.logManager;
    }

    @Override
    public LogOffset append(String streamUrn, Record record) {
        Name stream = Name.ofUrn(streamUrn);
        RecordFilterChain filter = this.filters.get(stream);
        if (filter == null) {
            throw new IllegalArgumentException("Unknown stream: " + stream);
        }
        if ((record = filter.beforeAppend(record)) == null) {
            return new LogOffsetImpl(stream, 0, 0L);
        }
        LogOffset offset = this.logManager.getAppender(stream).append(record.getKey(), record);
        filter.afterAppend(record, offset);
        return offset;
    }

    public boolean supportSubscribe() {
        return this.logManager.supportSubscribe();
    }

    public LogTailer<Record> subscribe(Name computationName, Collection<Name> streams, RebalanceListener listener) {
        Codec<Record> codec = this.getCodec(streams);
        return this.logManager.subscribe(computationName, streams, listener, codec);
    }

    public LogTailer<Record> createTailer(Name computationName, Collection<LogPartition> streamPartitions) {
        if (streamPartitions.isEmpty()) {
            return this.logManager.createTailer(computationName, streamPartitions);
        }
        Codec<Record> codec = this.getCodec(streamPartitions.stream().map(LogPartition::name).collect(Collectors.toList()));
        return this.logManager.createTailer(computationName, streamPartitions, codec);
    }

    public RecordFilter getFilter(Name stream) {
        return this.filters.get(stream);
    }

    protected Codec<Record> getCodec(Collection<Name> streams) {
        Codec codec = null;
        for (Name stream : streams) {
            Codec sCodec = this.logManager.getAppender(stream).getCodec();
            if (codec == null) {
                codec = sCodec;
                continue;
            }
            if (codec.getName().equals(sCodec.getName())) continue;
            throw new IllegalArgumentException("Different codec on input streams are not supported " + streams);
        }
        return codec;
    }

    protected void initStreams(Topology topology, Settings settings) {
        log.debug((Object)"Initializing streams");
        topology.streamsSet().forEach(streamName -> this.initStream((String)streamName, settings));
    }

    protected void initStream(String streamName, Settings settings) {
        Name stream = Name.ofUrn(streamName);
        if (settings.isExternal(stream)) {
            return;
        }
        if (!this.logManager.exists(stream)) {
            this.logManager.createIfNotExists(stream, settings.getPartitions(streamName));
        } else {
            int size = this.logManager.size(stream);
            if (settings.getPartitions(streamName) != size) {
                log.debug((Object)String.format("Update settings for stream: %s defined with %d partitions but exists with %d partitions", streamName, settings.getPartitions(streamName), size));
                settings.setPartitions(streamName, size);
            }
        }
        this.streams.add(stream);
    }

    protected void initAppenders(Collection<String> streams, Settings settings) {
        log.debug((Object)"Initializing source appenders so we ensure they use codec defined in the processor:");
        streams.forEach(stream -> log.debug(stream));
        streams.stream().filter(stream -> !settings.isExternal(Name.ofUrn(stream))).forEach(stream -> this.logManager.getAppender(Name.ofUrn(stream), settings.getCodec((String)stream)));
    }

    protected void registerFilters(Collection<String> streams, Settings settings) {
        streams.stream().filter(stream -> !settings.isExternal(Name.ofUrn(stream))).forEach(stream -> this.filters.put(Name.ofUrn(stream), settings.getFilterChain((String)stream)));
    }
}

