/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.log.chronicle;

import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;

public class ChronicleRetentionDuration {
    protected static final String SECOND_ROLLING_PERIOD = "s";
    protected static final String MINUTE_ROLLING_PERIOD = "m";
    protected static final String HOUR_ROLLING_PERIOD = "h";
    protected static final String DAY_ROLLING_PERIOD = "d";
    protected final RollCycle rollCycle;
    protected final int retentionCycles;
    protected final String retention;
    public static final ChronicleRetentionDuration NONE = new ChronicleRetentionDuration("0d");

    public ChronicleRetentionDuration(String retention) {
        this.retention = this.decodeRetention(retention);
        this.rollCycle = this.decodeRollCycle(this.retention);
        this.retentionCycles = this.decodeRetentionCycles(this.retention);
    }

    protected String decodeRetention(String retention) {
        if (retention == null || retention.isEmpty()) {
            return "0d";
        }
        return retention;
    }

    public String toString() {
        return this.retention;
    }

    public boolean disable() {
        return this.retentionCycles <= 0;
    }

    public RollCycle getRollCycle() {
        return this.rollCycle;
    }

    public String getRetention() {
        return this.retention;
    }

    public int getRetentionCycles() {
        return this.retentionCycles;
    }

    protected RollCycle decodeRollCycle(String retentionDuration) {
        String rollingPeriod;
        if (retentionDuration == null || retentionDuration.isEmpty()) {
            return RollCycles.DAILY;
        }
        switch (rollingPeriod = retentionDuration.substring(retentionDuration.length() - 1)) {
            case "s": {
                return RollCycles.TEST_SECONDLY;
            }
            case "m": {
                return RollCycles.MINUTELY;
            }
            case "h": {
                return RollCycles.HOURLY;
            }
            case "d": {
                return RollCycles.DAILY;
            }
        }
        throw new IllegalArgumentException("Unknown rolling period: " + rollingPeriod);
    }

    protected int decodeRetentionCycles(String retentionDuration) {
        if (retentionDuration != null) {
            return Integer.parseInt(retentionDuration.substring(0, retentionDuration.length() - 1));
        }
        return 0;
    }

    protected static String encodeRollCycle(RollCycle rollCycle) {
        if (rollCycle.equals(RollCycles.TEST_SECONDLY)) {
            return SECOND_ROLLING_PERIOD;
        }
        if (rollCycle.equals(RollCycles.MINUTELY)) {
            return MINUTE_ROLLING_PERIOD;
        }
        if (rollCycle.equals(RollCycles.HOURLY)) {
            return HOUR_ROLLING_PERIOD;
        }
        if (rollCycle.equals(RollCycles.DAILY)) {
            return DAY_ROLLING_PERIOD;
        }
        throw new IllegalArgumentException("Unknown rolling cycle: " + rollCycle);
    }

    public static ChronicleRetentionDuration disableOf(ChronicleRetentionDuration retention) {
        return new ChronicleRetentionDuration("0" + ChronicleRetentionDuration.encodeRollCycle(retention.getRollCycle()));
    }
}

