/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.tools;

import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.lib.stream.log.LogManager;
import org.nuxeo.lib.stream.log.chronicle.ChronicleLogManager;
import org.nuxeo.lib.stream.log.kafka.KafkaLogManager;
import org.nuxeo.lib.stream.tools.CommandRegistry;
import org.nuxeo.lib.stream.tools.KafkaConfigParser;
import org.nuxeo.lib.stream.tools.command.Command;
import org.nuxeo.lib.stream.tools.command.HelpCommand;

public class Main {
    private static final Log log = LogFactory.getLog(Main.class);
    protected static final String NUXEO_KAFKA_FILE_CONF = "nxserver/config/kafka-config.xml";
    protected static final String NUXEO_KAFKA_CONF = "default";
    protected static final String CHRONICLE_OPT = "chronicle";
    protected static final String KAFKA_OPT = "kafka";
    protected final Map<String, Command> commandMap = new HashMap<String, Command>();
    protected final Options options = new Options();
    protected String command;
    protected LogManager manager;

    public static void main(String[] args) {
        boolean success = new Main().run(args);
        if (!success) {
            System.exit(-1);
        }
    }

    public boolean run(String[] args) {
        this.initDefaultOptions();
        if (args == null || args.length == 0 || args[0].trim().isEmpty()) {
            this.command = "help";
            return this.runWithArgs(null);
        }
        this.command = Objects.requireNonNull(args)[0];
        return this.runWithArgs(Arrays.copyOfRange(args, 1, args.length));
    }

    protected boolean runWithArgs(String[] args) {
        try {
            Command cmd = this.getCommand();
            cmd.updateOptions(this.options);
            DefaultParser parser = new DefaultParser();
            CommandLine cmdLine = parser.parse(this.options, args);
            this.createManager(cmd, cmdLine);
            return cmd.run(this.manager, cmdLine);
        }
        catch (ParseException e) {
            log.error((Object)("Parse error: " + e.getMessage() + ", try: help " + this.command));
        }
        catch (IllegalArgumentException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error((Object)("Interrupted: " + e.getMessage()));
        }
        return false;
    }

    protected void createManager(Command cmd, CommandLine cmdLine) {
        if (cmd instanceof HelpCommand) {
            return;
        }
        if (cmdLine.hasOption(CHRONICLE_OPT)) {
            this.createChronicleManager(cmdLine.getOptionValue(CHRONICLE_OPT));
        } else if (cmdLine.hasOption(KAFKA_OPT) || cmdLine.hasOption("k")) {
            String contribPath = cmdLine.getOptionValue(KAFKA_OPT, NUXEO_KAFKA_FILE_CONF);
            this.createKafkaManager(contribPath, cmdLine.getOptionValue("kafka-config", NUXEO_KAFKA_CONF));
        } else {
            throw new IllegalArgumentException("Missing required option: --chronicle or --kafka");
        }
    }

    protected void createKafkaManager(String kafkaContribution, String kafkaConfig) {
        KafkaConfigParser config = new KafkaConfigParser(Paths.get(kafkaContribution, new String[0]), kafkaConfig);
        this.manager = new KafkaLogManager(config.getPrefix(), config.getProducerProperties(), config.getConsumerProperties());
    }

    protected void createChronicleManager(String basePath) {
        this.manager = new ChronicleLogManager(Paths.get(basePath, new String[0]));
    }

    protected Command getCommand() {
        if (this.commandMap.isEmpty()) {
            new CommandRegistry().commands().forEach(cmd -> this.commandMap.put(cmd.name(), (Command)cmd));
        }
        if ("-h".equals(this.command) || "--help".equals(this.command)) {
            this.command = "help";
        } else if (!this.commandMap.containsKey(this.command)) {
            throw new IllegalArgumentException("Unknown command: " + this.command);
        }
        return this.commandMap.get(this.command);
    }

    protected void initDefaultOptions() {
        this.options.addOption(Option.builder().longOpt(CHRONICLE_OPT).desc("Base path of the Chronicle Queue LogManager").hasArg().argName("PATH").build());
        this.options.addOption(Option.builder().longOpt(KAFKA_OPT).desc("Nuxeo Kafka configuration contribution file: nxserver/config/kafka-config.xml").hasArg().argName("PATH").build());
        this.options.addOption(Option.builder().longOpt("kafka-config").desc("Config name in the Nuxeo Kafka configuration contribution").hasArg().argName("CONFIG").build());
        this.options.addOption("k", "nuxeo-kafka", false, "Use the default Nuxeo Kafka configuration");
    }

    public LogManager getLogManager(String[] args) {
        this.run(args);
        return this.manager;
    }
}

