/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.tools.command;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.lib.stream.StreamRuntimeException;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.log.LogManager;
import org.nuxeo.lib.stream.log.LogPartition;
import org.nuxeo.lib.stream.log.LogRecord;
import org.nuxeo.lib.stream.log.LogTailer;
import org.nuxeo.lib.stream.log.Name;
import org.nuxeo.lib.stream.tools.command.Command;

public class DumpCommand
extends Command {
    private static final Log log = LogFactory.getLog(DumpCommand.class);
    protected static final String NAME = "dump";

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void updateOptions(Options options) {
        options.addOption(Option.builder((String)"n").longOpt("count").desc("Dump the first N records into a file").hasArg().argName("N").build());
        options.addOption(Option.builder((String)"l").longOpt("log-name").desc("Log name").required().hasArg().argName("LOG_NAME").build());
        options.addOption(Option.builder((String)"g").longOpt("group").desc("Consumer group").hasArg().argName("GROUP").build());
        options.addOption(Option.builder().longOpt("codec").desc("Codec used to read record, can be: java, avro, avroBinary, avroJson").hasArg().argName("CODEC").build());
        options.addOption(Option.builder((String)"p").longOpt("partition").desc("Read only this partition").hasArg().argName("PARTITION").build());
        options.addOption(Option.builder().longOpt("output").desc("Avro file path to dump the records").hasArg().required().argName("OUTPUT").build());
    }

    @Override
    public boolean run(LogManager manager, CommandLine cmd) throws InterruptedException {
        int limit = Integer.parseInt(cmd.getOptionValue("count", "-1"));
        Name name = Name.ofUrn(cmd.getOptionValue("log-name"));
        Name group = Name.ofUrn(cmd.getOptionValue("group", "admin/tools"));
        String codec = cmd.getOptionValue("codec");
        int partition = Integer.parseInt(cmd.getOptionValue("partition", "-1"));
        String output = cmd.getOptionValue("output");
        this.dump(manager, name, partition, group, limit, codec, Paths.get(output, new String[0]));
        return true;
    }

    protected void dump(LogManager manager, Name name, int partition, Name group, int limit, String codec, Path output) throws InterruptedException {
        log.info((Object)("Dump record to file: " + output));
        Schema schema = ReflectData.get().getSchema(Record.class);
        ReflectDatumWriter datumWriter = new ReflectDatumWriter(schema);
        int count = 0;
        try (DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);){
            dataFileWriter.setCodec(CodecFactory.snappyCodec());
            dataFileWriter.create(schema, output.toFile());
            try (LogTailer<Record> tailer = this.getTailer(manager, name, partition, group, codec);){
                do {
                    LogRecord<Record> record;
                    if ((record = tailer.read(Duration.ofMillis(1000L))) == null) {
                        break;
                    }
                    dataFileWriter.append((Object)record.message());
                } while (limit < 0 || ++count < limit);
            }
        }
        catch (IOException e) {
            throw new StreamRuntimeException(e);
        }
        log.info((Object)String.format("%d record(s) dumped", count));
    }

    protected LogTailer<Record> getTailer(LogManager manager, Name name, int partition, Name group, String codec) {
        if (partition >= 0) {
            return manager.createTailer(group, new LogPartition(name, partition), this.getRecordCodec(codec));
        }
        return manager.createTailer(group, name, this.getRecordCodec(codec));
    }
}

