/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.core.schema.DocumentTypeDescriptor;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.SchemaManagerImpl;
import org.nuxeo.ecm.platform.types.DocumentContentView;
import org.nuxeo.ecm.platform.types.DocumentContentViews;
import org.nuxeo.ecm.platform.types.Layouts;
import org.nuxeo.ecm.platform.types.SubType;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.types.TypeView;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class TypeRegistry
extends ContributionFragmentRegistry<Type> {
    protected Map<String, Type> types = new HashMap<String, Type>();
    protected Map<String, DocumentTypeDescriptor> dtds = new HashMap<String, DocumentTypeDescriptor>();

    public String getContributionId(Type contrib) {
        return contrib.getId();
    }

    public void contributionUpdated(String id, Type contrib, Type newOrigContrib) {
        if (contrib.getRemove()) {
            this.types.remove(id);
            this.removeCoreContribution(id);
        } else {
            this.types.put(id, contrib);
            this.updateCoreContribution(id, contrib);
        }
    }

    public void contributionRemoved(String id, Type origContrib) {
        this.types.remove(id);
        this.removeCoreContribution(id);
    }

    public Type clone(Type orig) {
        if (orig != null) {
            return orig.clone();
        }
        return null;
    }

    public void merge(Type newType, Type oldType) {
        String editView;
        String createView;
        String category;
        String description;
        String label;
        String bigIconExpanded;
        String bigIcon;
        String iconExpanded;
        boolean remove = newType.getRemove();
        boolean wasRemoved = oldType.getRemove();
        oldType.setRemove(remove);
        if (remove) {
            return;
        }
        String icon = newType.getIcon();
        if (icon != null || wasRemoved) {
            oldType.setIcon(icon);
        }
        if ((iconExpanded = newType.getIconExpanded()) != null || wasRemoved) {
            oldType.setIconExpanded(iconExpanded);
        }
        if ((bigIcon = newType.getBigIcon()) != null || wasRemoved) {
            oldType.setBigIcon(bigIcon);
        }
        if ((bigIconExpanded = newType.getBigIconExpanded()) != null || wasRemoved) {
            oldType.setBigIconExpanded(bigIconExpanded);
        }
        if ((label = newType.getLabel()) != null || wasRemoved) {
            oldType.setLabel(label);
        }
        if ((description = newType.getDescription()) != null || wasRemoved) {
            oldType.setDescription(description);
        }
        if ((category = newType.getCategory()) != null || wasRemoved) {
            oldType.setCategory(category);
        }
        Map<String, SubType> newTypeAllowedSubTypes = newType.getAllowedSubTypes();
        if (wasRemoved) {
            oldType.setAllowedSubTypes(newTypeAllowedSubTypes);
        } else {
            if (newTypeAllowedSubTypes != null) {
                Set<String> newTypeKeySet = newTypeAllowedSubTypes.keySet();
                Map<String, SubType> oldTypeAllowedSubTypes = oldType.getAllowedSubTypes();
                for (String newTypeKey : newTypeKeySet) {
                    oldTypeAllowedSubTypes.put(newTypeKey, newTypeAllowedSubTypes.get(newTypeKey));
                }
            }
            ArrayList<String> result = new ArrayList<String>();
            String[] deniedSubTypes = newType.getDeniedSubTypes();
            Map<String, SubType> oldTypeAllowedSubTypes = oldType.getAllowedSubTypes();
            boolean toAdd = true;
            if (oldTypeAllowedSubTypes != null) {
                Set<String> oldTypeKeySet = oldTypeAllowedSubTypes.keySet();
                for (String allowedSubType : oldTypeKeySet) {
                    for (String string : deniedSubTypes) {
                        if (!string.equals(allowedSubType)) continue;
                        toAdd = false;
                        break;
                    }
                    if (toAdd) {
                        result.add(allowedSubType);
                    }
                    toAdd = true;
                }
            }
            HashMap<String, SubType> mapResult = new HashMap<String, SubType>();
            for (String resultTypeName : result) {
                mapResult.put(resultTypeName, oldTypeAllowedSubTypes.get(resultTypeName));
            }
            oldType.setAllowedSubTypes(mapResult);
        }
        String defaultView = newType.getDefaultView();
        if (defaultView != null || wasRemoved) {
            oldType.setDefaultView(defaultView);
        }
        if ((createView = newType.getCreateView()) != null || wasRemoved) {
            oldType.setCreateView(createView);
        }
        if ((editView = newType.getEditView()) != null || wasRemoved) {
            oldType.setEditView(editView);
        }
        for (TypeView view : newType.getViews()) {
            oldType.setView(view);
        }
        Map<String, Layouts> layouts = newType.getLayouts();
        if (wasRemoved) {
            oldType.setLayouts(layouts);
        } else if (layouts != null) {
            HashMap<String, Layouts> layoutsMerged = new HashMap<String, Layouts>(oldType.getLayouts());
            for (Map.Entry<String, Layouts> entry : layouts.entrySet()) {
                String key = entry.getKey();
                Layouts newLayouts = entry.getValue();
                if (layoutsMerged.containsKey(key) && newLayouts.getAppend()) {
                    ArrayList<String> allLayouts = new ArrayList<String>();
                    for (String layoutName : ((Layouts)layoutsMerged.get(key)).getLayouts()) {
                        allLayouts.add(layoutName);
                    }
                    for (String layoutName : newLayouts.getLayouts()) {
                        allLayouts.add(layoutName);
                    }
                    Layouts layouts2 = new Layouts();
                    layouts2.layouts = allLayouts.toArray(new String[allLayouts.size()]);
                    layoutsMerged.put(key, layouts2);
                    continue;
                }
                layoutsMerged.put(key, newLayouts);
            }
            oldType.setLayouts(layoutsMerged);
        }
        Map<String, DocumentContentViews> contentViews = newType.getContentViews();
        if (wasRemoved) {
            oldType.setContentViews(contentViews);
        } else if (contentViews != null) {
            HashMap<String, DocumentContentViews> cvMerged = new HashMap<String, DocumentContentViews>(oldType.getContentViews());
            for (Map.Entry<String, DocumentContentViews> entry : contentViews.entrySet()) {
                String key = entry.getKey();
                DocumentContentViews newContentViews = entry.getValue();
                if (cvMerged.containsKey(key) && newContentViews.getAppend()) {
                    ArrayList<DocumentContentView> arrayList = new ArrayList<DocumentContentView>();
                    for (DocumentContentView cv : ((DocumentContentViews)cvMerged.get(key)).getContentViews()) {
                        arrayList.add(cv);
                    }
                    for (DocumentContentView cv : newContentViews.getContentViews()) {
                        arrayList.add(cv);
                    }
                    DocumentContentViews mergedContentViews = new DocumentContentViews();
                    mergedContentViews.contentViews = arrayList.toArray(new DocumentContentView[arrayList.size()]);
                    cvMerged.put(key, mergedContentViews);
                    continue;
                }
                cvMerged.put(key, newContentViews);
            }
            oldType.setContentViews(cvMerged);
        }
    }

    public boolean hasType(String id) {
        return this.types.containsKey(id);
    }

    public Collection<Type> getTypes() {
        return Collections.unmodifiableCollection(this.types.values());
    }

    public Type getType(String id) {
        return this.types.get(id);
    }

    protected void recomputeTypes() {
        for (Type type : this.types.values()) {
            type.setAllowedSubTypes(this.getCoreAllowedSubtypes(type));
            type.setDeniedSubTypes(new String[0]);
        }
    }

    protected Map<String, SubType> getCoreAllowedSubtypes(Type type) {
        SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        Set coreAllowedSubtypes = schemaManager.getAllowedSubTypes(type.getId());
        if (coreAllowedSubtypes == null) {
            return Collections.emptyMap();
        }
        Map<String, SubType> ecmSubTypes = type.getAllowedSubTypes();
        HashMap<String, SubType> allowedSubTypes = new HashMap<String, SubType>();
        for (String name : coreAllowedSubtypes) {
            SubType subtype;
            if (ecmSubTypes.containsKey(name)) {
                subtype = ecmSubTypes.get(name);
            } else {
                subtype = new SubType();
                subtype.setName(name);
            }
            allowedSubTypes.put(name, subtype);
        }
        return allowedSubTypes;
    }

    protected void updateCoreContribution(String id, Type contrib) {
        SchemaManagerImpl schemaManager = (SchemaManagerImpl)Framework.getService(SchemaManager.class);
        if (this.dtds.containsKey(id)) {
            schemaManager.unregisterDocumentType(this.dtds.get(id));
            this.dtds.remove(id);
        }
        DocumentTypeDescriptor dtd = new DocumentTypeDescriptor();
        dtd.name = contrib.getId();
        dtd.subtypes = contrib.getAllowedSubTypes().keySet().toArray(new String[contrib.getAllowedSubTypes().size()]);
        dtd.forbiddenSubtypes = contrib.getDeniedSubTypes();
        dtd.append = true;
        if (dtd.subtypes.length > 0 || dtd.forbiddenSubtypes.length > 0) {
            this.dtds.put(id, dtd);
            schemaManager.registerDocumentType(dtd);
        }
    }

    protected void removeCoreContribution(String id) {
        if (this.dtds.containsKey(id)) {
            SchemaManagerImpl schemaManager = (SchemaManagerImpl)Framework.getService(SchemaManager.class);
            schemaManager.unregisterDocumentType(this.dtds.get(id));
            this.dtds.remove(id);
        }
    }
}

