/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.jaxrs.io.management;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.nuxeo.ecm.admin.runtime.SimplifiedBundleInfo;
import org.nuxeo.ecm.admin.runtime.SimplifiedServerInfo;
import org.nuxeo.ecm.core.io.marshallers.json.ExtensibleEntityJsonWriter;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class SimplifiedServerInfoJsonWriter
extends ExtensibleEntityJsonWriter<SimplifiedServerInfo> {
    public static final String ENTITY_TYPE = "serverInfo";

    public SimplifiedServerInfoJsonWriter() {
        super(ENTITY_TYPE, SimplifiedServerInfo.class);
    }

    protected void writeEntityBody(SimplifiedServerInfo entity, JsonGenerator jg) throws IOException {
        jg.writeStringField("applicationName", entity.getApplicationName());
        jg.writeStringField("applicationVersion", entity.getApplicationVersion());
        jg.writeStringField("distributionName", entity.getDistributionName());
        jg.writeStringField("distributionVersion", entity.getDistributionVersion());
        jg.writeStringField("distributionDate", entity.getDistributionDate());
        jg.writeArrayFieldStart("bundles");
        for (SimplifiedBundleInfo b : entity.getBundleInfos()) {
            jg.writeStartObject();
            jg.writeStringField("name", b.getName());
            jg.writeStringField("version", b.getVersion());
            jg.writeEndObject();
        }
        jg.writeEndArray();
        jg.writeArrayFieldStart("warnings");
        for (String w : entity.getWarnings()) {
            jg.writeStartObject();
            jg.writeStringField("message", w);
            jg.writeEndObject();
        }
        jg.writeEndArray();
        jg.writeArrayFieldStart("errors");
        for (String w : entity.getErrors()) {
            jg.writeStartObject();
            jg.writeStringField("message", w);
            jg.writeEndObject();
        }
        jg.writeEndArray();
    }
}

