/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.security;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.bulk.action.computation.AbstractBulkComputation;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.lib.stream.computation.Topology;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.stream.StreamProcessorTopology;

public class RetentionExpiredAction
implements StreamProcessorTopology {
    public static final String ACTION_NAME = "retentionExpired";
    public static final String ACTION_FULL_NAME = "retention/retentionExpired";

    public Topology getTopology(Map<String, String> options) {
        return Topology.builder().addComputation(RetentionExpiredComputation::new, Arrays.asList("i1:retention/retentionExpired", "o1:bulk/status")).build();
    }

    public static class RetentionExpiredComputation
    extends AbstractBulkComputation {
        private static final Logger log = LogManager.getLogger(RetentionExpiredComputation.class);

        public RetentionExpiredComputation() {
            super(RetentionExpiredAction.ACTION_FULL_NAME);
        }

        protected void compute(CoreSession session, List<String> ids, Map<String, Serializable> properties) {
            Collection refs = ids.stream().map(IdRef::new).collect(Collectors.toList());
            for (DocumentRef ref : refs) {
                if (!session.isRecord(ref)) {
                    log.debug("Document: {} is not a record", (Object)ref);
                    continue;
                }
                Calendar retainUntil = session.getRetainUntil(ref);
                if (retainUntil == null) {
                    log.debug("Document: {} was not under retention", (Object)ref);
                    continue;
                }
                if (RetentionExpiredComputation.isUnderRetention(retainUntil)) {
                    Supplier[] supplierArray = new Supplier[2];
                    supplierArray[0] = () -> ref;
                    supplierArray[1] = retainUntil::toInstant;
                    log.debug("Document: {} is still under retention: {}", supplierArray);
                    continue;
                }
                try {
                    session.setRetainUntil(ref, null, null);
                    this.sendEvent(session, ref, retainUntil);
                }
                catch (NuxeoException e) {
                    log.warn("Cannot reset retention on: {}", (Object)ref, (Object)e);
                }
            }
            try {
                session.save();
            }
            catch (PropertyException e) {
                log.warn("Cannot save session", (Throwable)e);
            }
        }

        protected static boolean isUnderRetention(Calendar retainUntil) {
            return retainUntil != null && Calendar.getInstance().before(retainUntil);
        }

        protected void sendEvent(CoreSession session, DocumentRef ref, Calendar retainUntil) {
            DocumentModel doc = session.getDocument(ref);
            DocumentEventContext ctx = new DocumentEventContext(session, null, doc);
            ctx.setProperty("repositoryName", (Serializable)((Object)session.getRepositoryName()));
            ctx.setProperty("category", (Serializable)((Object)"eventDocumentCategory"));
            ctx.setProperty("retainUntil", (Serializable)retainUntil);
            ctx.setProperty("comment", (Serializable)((Object)retainUntil.toInstant().toString()));
            Event event = ctx.newEvent(RetentionExpiredAction.ACTION_NAME);
            ((EventService)Framework.getService(EventService.class)).fireEvent(event);
        }
    }
}

