/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.impl.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.impl.CompoundFilter;
import org.nuxeo.ecm.core.api.impl.FacetFilter;
import org.nuxeo.ecm.core.api.tree.DefaultDocumentTreeSorter;
import org.nuxeo.ecm.platform.publisher.api.AbstractPublicationNode;
import org.nuxeo.ecm.platform.publisher.api.PublicationNode;
import org.nuxeo.ecm.platform.publisher.api.PublicationTree;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocumentFactory;
import org.nuxeo.ecm.platform.publisher.impl.core.VirtualCoreFolderPublicationNode;

public class CoreFolderPublicationNode
extends AbstractPublicationNode {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_SORT_PROP_NAME = "dc:title";
    protected DocumentModel folder;
    protected PublicationNode parent;
    protected List<PublicationNode> childrenNodes;
    protected PublishedDocumentFactory factory;

    public CoreFolderPublicationNode(DocumentModel doc, PublicationTree tree, PublicationNode parent, PublishedDocumentFactory factory) {
        super(tree);
        this.folder = doc;
        this.parent = parent;
        this.factory = factory;
    }

    public CoreFolderPublicationNode(DocumentModel doc, PublicationTree tree, PublishedDocumentFactory factory) {
        super(tree);
        this.folder = doc;
        this.factory = factory;
    }

    protected CoreSession getCoreSession() {
        return this.folder.getCoreSession();
    }

    protected String buildChildrenWhereClause(boolean queryDocuments) {
        Object clause = String.format("ecm:parentId = '%s' AND ecm:isTrashed = 0", this.folder.getId());
        clause = queryDocuments ? (String)clause + String.format(" AND ecm:mixinType NOT IN ('%s', '%s')", "PublishSpace", "HiddenInNavigation") : (String)clause + String.format("AND ecm:mixinType IN ('%s') AND ecm:mixinType NOT IN ('%s')", "PublishSpace", "HiddenInNavigation");
        return clause;
    }

    @Override
    public List<PublishedDocument> getChildrenDocuments() {
        DocumentModelList children = this.getSortedChildren(true);
        ArrayList<PublishedDocument> childrenDocs = new ArrayList<PublishedDocument>();
        for (DocumentModel child : children) {
            childrenDocs.add(this.factory.wrapDocumentModel(child));
        }
        return childrenDocs;
    }

    @Override
    public List<PublicationNode> getChildrenNodes() {
        if (this.childrenNodes == null) {
            DocumentModelList children = this.getSortedChildren(false);
            this.childrenNodes = new ArrayList<PublicationNode>();
            for (DocumentModel child : children) {
                this.childrenNodes.add(new CoreFolderPublicationNode(child, this.tree, this, this.factory));
            }
        }
        return this.childrenNodes;
    }

    protected DocumentModelList getOrderedChildren() {
        return this.getCoreSession().getChildren(this.folder.getRef(), null, null, this.computeGetChildrenFilter(), null);
    }

    protected Filter computeGetChildrenFilter() {
        FacetFilter facetFilter = new FacetFilter(Arrays.asList("Folderish"), Arrays.asList("HiddenInNavigation"));
        Filter trashedFilter = docModel -> !docModel.isTrashed();
        return new CompoundFilter(new Filter[]{facetFilter, trashedFilter});
    }

    protected DocumentModelList getSortedChildren(boolean queryDocuments) {
        String whereClause = this.buildChildrenWhereClause(queryDocuments);
        DocumentModelList children = this.getCoreSession().query("SELECT * FROM Document WHERE " + whereClause);
        if (!this.folder.hasFacet("Orderable")) {
            DefaultDocumentTreeSorter sorter = new DefaultDocumentTreeSorter();
            sorter.setSortPropertyPath(DEFAULT_SORT_PROP_NAME);
            Collections.sort(children, sorter);
        }
        return children;
    }

    @Override
    public String getTitle() {
        return this.folder.getTitle();
    }

    @Override
    public String getName() {
        return this.folder.getName();
    }

    @Override
    public PublicationNode getParent() {
        if (this.parent == null) {
            DocumentRef docRef = this.folder.getParentRef();
            this.parent = this.getCoreSession().hasPermission(docRef, "Read") ? new CoreFolderPublicationNode(this.getCoreSession().getDocument(this.folder.getParentRef()), this.tree, this.factory) : new VirtualCoreFolderPublicationNode(this.getCoreSession(), docRef.toString(), this.tree, this.factory);
        }
        return this.parent;
    }

    @Override
    public String getPath() {
        return this.folder.getPathAsString();
    }

    public DocumentRef getTargetDocumentRef() {
        return this.folder.getRef();
    }

    public DocumentModel getTargetDocumentModel() {
        return this.folder;
    }
}

