/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.metrics;

import io.dropwizard.metrics5.Counter;
import io.dropwizard.metrics5.Metric;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.SharedMetricRegistries;
import io.dropwizard.metrics5.jvm.BufferPoolMetricSet;
import io.dropwizard.metrics5.jvm.FileDescriptorRatioGauge;
import io.dropwizard.metrics5.jvm.GarbageCollectorMetricSet;
import io.dropwizard.metrics5.jvm.JmxAttributeGauge;
import io.dropwizard.metrics5.jvm.MemoryUsageGaugeSet;
import io.dropwizard.metrics5.jvm.ThreadStatesGaugeSet;
import io.dropwizard.metrics5.log4j2.InstrumentedAppender;
import java.lang.management.ManagementFactory;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.metrics.MetricsConfigurationDescriptor;
import org.nuxeo.runtime.metrics.MetricsReporter;
import org.nuxeo.runtime.metrics.MetricsReporterDescriptor;
import org.nuxeo.runtime.metrics.MetricsService;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class MetricsServiceImpl
extends DefaultComponent
implements MetricsService {
    private static final Logger log = LogManager.getLogger(MetricsServiceImpl.class);
    protected static final String CONFIGURATION_EP = "configuration";
    protected static final String REPORTER_EP = "reporter";
    protected MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    protected final Counter instanceUp = this.registry.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"instance-up"}));
    protected MetricsConfigurationDescriptor config;
    protected List<MetricsReporterDescriptor> reporterConfigs;
    protected List<MetricsReporter> reporters;
    protected InstrumentedAppender appender;

    public void activate(ComponentContext context) {
        super.activate(context);
        log.debug("Activating component");
        SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    }

    public void deactivate(ComponentContext context) {
        log.debug("Deactivating component");
        SharedMetricRegistries.remove((String)MetricsService.class.getName());
        super.deactivate(context);
    }

    public void start(ComponentContext context) {
        super.start(context);
        log.debug("Starting component");
        this.instanceUp.inc();
        this.config = (MetricsConfigurationDescriptor)this.getDescriptor(CONFIGURATION_EP, "");
        this.startReporters();
    }

    public void stop(ComponentContext context) {
        log.debug("Stopping component");
        this.stopReporters();
        this.instanceUp.dec();
    }

    protected boolean metricEnabled() {
        return this.config != null && this.config.isEnabled();
    }

    @Override
    public void startReporters() {
        if (!this.metricEnabled() || this.reporters != null) {
            log.debug("Metrics disabled or already started.");
            return;
        }
        log.info("Starting reporters");
        this.reporterConfigs = this.getDescriptors(REPORTER_EP);
        this.updateInstrumentation(this.config.getInstruments(), true);
        this.reporters = this.reporterConfigs.stream().filter(MetricsReporterDescriptor::isEnabled).map(MetricsReporterDescriptor::newInstance).collect(Collectors.toList());
        this.reporters.forEach(reporter -> reporter.start(this.registry, this.config, this.config.getDeniedExpansions()));
    }

    @Override
    public void stopReporters() {
        if (!this.metricEnabled() || this.reporters == null) {
            log.debug("Metrics disabled or already stopped.");
            return;
        }
        log.warn("Stopping reporters");
        this.reporters.forEach(MetricsReporter::stop);
        this.updateInstrumentation(this.config.getInstruments(), false);
        this.reporters.clear();
        this.reporters = null;
        this.reporterConfigs = null;
    }

    protected void updateInstrumentation(List<MetricsConfigurationDescriptor.InstrumentDescriptor> instruments, boolean activate) {
        Iterator iterator = instruments.stream().filter(MetricsConfigurationDescriptor.InstrumentDescriptor::isEnabled).map(MetricsConfigurationDescriptor.InstrumentDescriptor::getId).collect(Collectors.toList()).iterator();
        block10: while (iterator.hasNext()) {
            String instrument;
            switch (instrument = (String)iterator.next()) {
                case "log4j": {
                    this.instrumentLog4j(activate);
                    continue block10;
                }
                case "tomcat": {
                    this.instrumentTomcat(activate);
                    continue block10;
                }
                case "jvm": {
                    this.instrumentJvm(activate);
                    continue block10;
                }
            }
            log.warn("Ignoring unknown instrumentation: " + instrument);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void instrumentLog4j(boolean activate) {
        if (activate) {
            this.appender = new InstrumentedAppender(this.registry, null, null, false);
            this.appender.start();
            LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
            Configuration config = context.getConfiguration();
            config.getLoggerConfig("").addAppender((Appender)this.appender, Level.INFO, null);
            context.updateLoggers(config);
        } else if (this.appender != null) {
            try {
                LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
                Configuration config = context.getConfiguration();
                config.getLoggerConfig("").removeAppender(this.appender.getName());
                context.updateLoggers(config);
            }
            finally {
                this.appender = null;
            }
        }
    }

    protected void registerTomcatGauge(String mbean, String attribute, MetricRegistry registry, String name) {
        try {
            registry.register(MetricRegistry.name((String)"tomcat", (String[])new String[]{name}), (Metric)new JmxAttributeGauge(new ObjectName(mbean), attribute));
        }
        catch (IllegalArgumentException | MalformedObjectNameException e) {
            throw new UnsupportedOperationException("Cannot compute object name of " + mbean, e);
        }
    }

    protected void instrumentTomcat(boolean activate) {
        if (activate) {
            String pool = "org.nuxeo.ecm.core.management.jtajca:type=ConnectionPoolMonitor,name=jdbc/nuxeo";
            String connector = String.format("Catalina:type=ThreadPool,name=\"http-nio-%s-%s\"", Framework.getProperty((String)"nuxeo.bind.address", (String)"0.0.0.0"), Framework.getProperty((String)"nuxeo.bind.port", (String)"8080"));
            String requestProcessor = String.format("Catalina:type=GlobalRequestProcessor,name=\"http-nio-%s-%s\"", Framework.getProperty((String)"nuxeo.bind.address", (String)"0.0.0.0"), Framework.getProperty((String)"nuxeo.bind.port", (String)"8080"));
            String manager = "Catalina:type=Manager,host=localhost,context=/nuxeo";
            this.registerTomcatGauge(pool, "ConnectionCount", this.registry, "jdbc-numActive");
            this.registerTomcatGauge(pool, "IdleConnectionCount", this.registry, "jdbc-numIdle");
            this.registerTomcatGauge(connector, "currentThreadCount", this.registry, "currentThreadCount");
            this.registerTomcatGauge(connector, "currentThreadsBusy", this.registry, "currentThreadBusy");
            this.registerTomcatGauge(requestProcessor, "errorCount", this.registry, "errorCount");
            this.registerTomcatGauge(requestProcessor, "requestCount", this.registry, "requestCount");
            this.registerTomcatGauge(requestProcessor, "processingTime", this.registry, "processingTime");
            this.registerTomcatGauge(requestProcessor, "bytesReceived", this.registry, "bytesReceived");
            this.registerTomcatGauge(requestProcessor, "bytesSent", this.registry, "bytesSent");
            this.registerTomcatGauge(manager, "activeSessions", this.registry, "activeSessions");
        } else {
            this.registry.removeMatching((name, metric) -> name.getKey().startsWith("tomcat."));
        }
    }

    protected void instrumentJvm(boolean activate) {
        if (activate) {
            this.registry.register("jvm.memory", (Metric)new MemoryUsageGaugeSet());
            this.registry.register("jvm.garbage", (Metric)new GarbageCollectorMetricSet());
            this.registry.register("jvm.threads", (Metric)new ThreadStatesGaugeSet());
            this.registry.register("jvm.files", (Metric)new FileDescriptorRatioGauge());
            this.registry.register("jvm.buffers", (Metric)new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()));
        } else {
            this.registry.removeMatching((name, metric) -> name.getKey().startsWith("jvm."));
        }
    }
}

