/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth.tokens;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.oauth.tokens.NuxeoOAuthToken;
import org.nuxeo.ecm.platform.oauth.tokens.OAuthToken;
import org.nuxeo.ecm.platform.oauth.tokens.OAuthTokenStore;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class OAuthTokenStoreImpl
extends DefaultComponent
implements OAuthTokenStore {
    protected static final Log log = LogFactory.getLog(OAuthTokenStoreImpl.class);
    public static final String DIRECTORY_NAME = "oauthTokens";
    protected Map<String, OAuthToken> requestTokenStore = new HashMap<String, OAuthToken>();

    @Override
    public OAuthToken addVerifierToRequestToken(String token, Long duration) {
        NuxeoOAuthToken rToken = (NuxeoOAuthToken)this.getRequestToken(token);
        if (rToken != null) {
            rToken.verifier = "NX-VERIF-" + UUID.randomUUID().toString();
            rToken.durationInMinutes = duration;
        }
        return rToken;
    }

    @Override
    public OAuthToken createAccessTokenFromRequestToken(OAuthToken requestToken) {
        NuxeoOAuthToken aToken = new NuxeoOAuthToken((NuxeoOAuthToken)requestToken);
        String token = "NX-AT-" + UUID.randomUUID().toString();
        aToken.token = token;
        aToken.tokenSecret = "NX-ATS-" + UUID.randomUUID().toString();
        aToken.type = OAuthToken.Type.ACCESS;
        try {
            aToken = this.storeAccessTokenAsDirectoryEntry(aToken);
            this.removeRequestToken(requestToken.getToken());
            return aToken;
        }
        catch (DirectoryException e) {
            log.error((Object)"Error during directory persistence", (Throwable)e);
            return null;
        }
    }

    @Override
    public NuxeoOAuthToken getClientAccessToken(String appId, String owner) {
        DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
        try (Session session = ds.open(DIRECTORY_NAME);){
            HashMap<String, Object> filter = new HashMap<String, Object>();
            filter.put("appId", appId);
            filter.put("clientId", owner);
            filter.put("clientToken", 1);
            DocumentModelList entries = session.query(filter);
            if (entries.size() == 0) {
                NuxeoOAuthToken nuxeoOAuthToken = null;
                return nuxeoOAuthToken;
            }
            if (entries.size() > 1) {
                log.error((Object)"Found several tokens");
            }
            NuxeoOAuthToken nuxeoOAuthToken = this.getTokenFromDirectoryEntry((DocumentModel)entries.get(0));
            return nuxeoOAuthToken;
        }
    }

    @Override
    public void removeClientAccessToken(String appId, String owner) {
        DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
        try (Session session = ds.open(DIRECTORY_NAME);){
            HashMap<String, Object> filter = new HashMap<String, Object>();
            filter.put("appId", appId);
            filter.put("clientId", owner);
            filter.put("clientToken", 1);
            DocumentModelList entries = session.query(filter);
            if (entries.size() == 0) {
                return;
            }
            if (entries.size() > 1) {
                log.error((Object)"Found several tokens");
            }
            session.deleteEntry((DocumentModel)entries.get(0));
        }
    }

    @Override
    public void storeClientAccessToken(String consumerKey, String callBack, String token, String tokenSecret, String appId, String owner) {
        NuxeoOAuthToken aToken = new NuxeoOAuthToken(consumerKey, callBack);
        aToken.token = token;
        aToken.tokenSecret = tokenSecret;
        if (appId != null) {
            aToken.appId = appId;
        }
        aToken.clientToken = true;
        aToken.clientId = owner;
        try {
            aToken = this.storeAccessTokenAsDirectoryEntry(aToken);
        }
        catch (DirectoryException e) {
            log.error((Object)"Error during directory persistence", (Throwable)e);
        }
    }

    protected NuxeoOAuthToken getTokenFromDirectory(String token) {
        DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
        return (NuxeoOAuthToken)Framework.doPrivileged(() -> {
            try (Session session = ds.open(DIRECTORY_NAME);){
                DocumentModel entry = session.getEntry(token);
                if (entry == null) {
                    NuxeoOAuthToken nuxeoOAuthToken = null;
                    return nuxeoOAuthToken;
                }
                NuxeoOAuthToken nuxeoOAuthToken = this.getTokenFromDirectoryEntry(entry);
                return nuxeoOAuthToken;
            }
        });
    }

    protected NuxeoOAuthToken getTokenFromDirectoryEntry(DocumentModel entry) {
        return new NuxeoOAuthToken(entry);
    }

    protected NuxeoOAuthToken storeAccessTokenAsDirectoryEntry(NuxeoOAuthToken aToken) {
        DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
        return (NuxeoOAuthToken)Framework.doPrivileged(() -> {
            try (Session session = ds.open(DIRECTORY_NAME);){
                DocumentModel entry = session.getEntry(aToken.getToken());
                if (entry == null) {
                    entry = session.createEntry(Collections.singletonMap("token", aToken.getToken()));
                }
                aToken.updateEntry(entry);
                session.updateEntry(entry);
                NuxeoOAuthToken nuxeoOAuthToken = this.getTokenFromDirectoryEntry(session.getEntry(aToken.getToken()));
                return nuxeoOAuthToken;
            }
        });
    }

    @Override
    public OAuthToken createRequestToken(String consumerKey, String callBack) {
        NuxeoOAuthToken rToken = new NuxeoOAuthToken(consumerKey, callBack);
        String token = "NX-RT-" + consumerKey + "-" + UUID.randomUUID().toString();
        rToken.token = token;
        rToken.tokenSecret = "NX-RTS-" + consumerKey + UUID.randomUUID().toString();
        rToken.type = OAuthToken.Type.REQUEST;
        this.requestTokenStore.put(token, rToken);
        return rToken;
    }

    @Override
    public OAuthToken getAccessToken(String token) {
        try {
            return this.getTokenFromDirectory(token);
        }
        catch (DirectoryException e) {
            log.error((Object)"Error while accessing Token SQL storage", (Throwable)e);
            return null;
        }
    }

    @Override
    public OAuthToken getRequestToken(String token) {
        return this.requestTokenStore.get(token);
    }

    @Override
    public List<OAuthToken> listAccessTokenForConsumer(String consumerKey) {
        ArrayList<OAuthToken> result = new ArrayList<OAuthToken>();
        DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
        try (Session session = ds.open(DIRECTORY_NAME);){
            HashMap<String, Object> filter = new HashMap<String, Object>();
            filter.put("consumerKey", consumerKey);
            filter.put("clientToken", 0);
            DocumentModelList entries = session.query(filter);
            for (DocumentModel entry : entries) {
                result.add(new NuxeoOAuthToken(entry));
            }
        }
        catch (DirectoryException e) {
            log.error((Object)"Error during token listing", (Throwable)e);
        }
        return result;
    }

    @Override
    public List<OAuthToken> listAccessTokenForUser(String login) {
        ArrayList<OAuthToken> result = new ArrayList<OAuthToken>();
        DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
        try (Session session = ds.open(DIRECTORY_NAME);){
            HashMap<String, Object> filter = new HashMap<String, Object>();
            filter.put("nuxeoLogin", login);
            filter.put("clientToken", 0);
            DocumentModelList entries = session.query(filter);
            for (DocumentModel entry : entries) {
                result.add(new NuxeoOAuthToken(entry));
            }
        }
        catch (DirectoryException e) {
            log.error((Object)"Error during token listing", (Throwable)e);
        }
        return result;
    }

    @Override
    public void removeAccessToken(String token) {
        DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
        try (Session session = ds.open(DIRECTORY_NAME);){
            session.deleteEntry(token);
        }
    }

    @Override
    public void removeRequestToken(String token) {
        this.requestTokenStore.remove(token);
    }
}

