/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.externalsorting.csv;

import com.google.code.externalsorting.csv.CSVRecordBuffer;
import com.google.code.externalsorting.csv.CsvSortOptions;
import com.google.code.externalsorting.csv.SizeEstimator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;

public class CsvExternalSort {
    private static final Logger LOG = Logger.getLogger(CsvExternalSort.class.getName());
    public static final int DEFAULTMAXTEMPFILES = 1024;

    private CsvExternalSort() {
        throw new UnsupportedOperationException("Unable to instantiate utility class");
    }

    public static long estimateAvailableMemory() {
        System.gc();
        return Runtime.getRuntime().freeMemory();
    }

    public static long estimateBestSizeOfBlocks(long sizeoffile, int maxtmpfiles, long maxMemory) {
        long blocksize = sizeoffile / (long)maxtmpfiles + (long)(sizeoffile % (long)maxtmpfiles == 0L ? 0 : 1);
        if (blocksize < maxMemory / 6L) {
            blocksize = maxMemory / 6L;
        }
        return blocksize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int mergeSortedFiles(BufferedWriter fbw, final CsvSortOptions sortOptions, List<CSVRecordBuffer> bfbs, List<CSVRecord> header) throws IOException, ClassNotFoundException {
        PriorityQueue<CSVRecordBuffer> pq = new PriorityQueue<CSVRecordBuffer>(11, new Comparator<CSVRecordBuffer>(){

            @Override
            public int compare(CSVRecordBuffer i, CSVRecordBuffer j) {
                return sortOptions.getComparator().compare(i.peek(), j.peek());
            }
        });
        for (CSVRecordBuffer bfb : bfbs) {
            if (bfb.empty()) continue;
            pq.add(bfb);
        }
        int rowcounter = 0;
        CSVPrinter printer = new CSVPrinter((Appendable)fbw, sortOptions.getFormat());
        if (!sortOptions.isSkipHeader()) {
            for (CSVRecord r : header) {
                printer.printRecord((Iterable)r);
            }
        }
        CSVRecord lastLine = null;
        try {
            while (pq.size() > 0) {
                CSVRecordBuffer bfb = pq.poll();
                CSVRecord r = bfb.pop();
                if (!sortOptions.isDistinct() || !CsvExternalSort.checkDuplicateLine(r, lastLine)) {
                    printer.printRecord((Iterable)r);
                    lastLine = r;
                }
                ++rowcounter;
                if (bfb.empty()) {
                    bfb.close();
                    continue;
                }
                pq.add(bfb);
            }
        }
        finally {
            printer.close();
            fbw.close();
            for (CSVRecordBuffer bfb : pq) {
                bfb.close();
            }
        }
        return rowcounter;
    }

    public static int mergeSortedFiles(List<File> files, File outputfile, CsvSortOptions sortOptions, boolean append, List<CSVRecord> header) throws IOException, ClassNotFoundException {
        ArrayList<CSVRecordBuffer> bfbs = new ArrayList<CSVRecordBuffer>();
        for (File f : files) {
            FileInputStream in = new FileInputStream(f);
            BufferedReader fbr = new BufferedReader(new InputStreamReader((InputStream)in, sortOptions.getCharset()));
            CSVParser parser = new CSVParser((Reader)fbr, sortOptions.getFormat());
            CSVRecordBuffer bfb = new CSVRecordBuffer(parser);
            bfbs.add(bfb);
        }
        BufferedWriter fbw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputfile, append), sortOptions.getCharset()));
        int rowcounter = CsvExternalSort.mergeSortedFiles(fbw, sortOptions, bfbs, header);
        for (File f : files) {
            if (f.delete()) continue;
            LOG.log(Level.WARNING, String.format("The file %s was not deleted", f.getName()));
        }
        return rowcounter;
    }

    public static List<File> sortInBatch(long size_in_byte, BufferedReader fbr, File tmpdirectory, CsvSortOptions sortOptions, List<CSVRecord> header) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        long blocksize = CsvExternalSort.estimateBestSizeOfBlocks(size_in_byte, sortOptions.getMaxTmpFiles(), sortOptions.getMaxMemory());
        AtomicLong currentBlock = new AtomicLong(0L);
        ArrayList<CSVRecord> tmplist = new ArrayList<CSVRecord>();
        try (CSVParser parser = new CSVParser((Reader)fbr, sortOptions.getFormat());){
            parser.spliterator().forEachRemaining(e -> {
                if (e.getRecordNumber() <= (long)sortOptions.getNumHeader()) {
                    header.add((CSVRecord)e);
                } else {
                    tmplist.add((CSVRecord)e);
                    currentBlock.addAndGet(SizeEstimator.estimatedSizeOf(e));
                }
                if (currentBlock.get() >= blocksize) {
                    try {
                        files.add(CsvExternalSort.sortAndSave(tmplist, tmpdirectory, sortOptions));
                    }
                    catch (IOException e1) {
                        LOG.log(Level.WARNING, String.format("Error during the sort in batch", new Object[0]), e1);
                    }
                    tmplist.clear();
                    currentBlock.getAndSet(0L);
                }
            });
        }
        if (!tmplist.isEmpty()) {
            files.add(CsvExternalSort.sortAndSave(tmplist, tmpdirectory, sortOptions));
        }
        return files;
    }

    public static File sortAndSave(List<CSVRecord> tmplist, File tmpdirectory, CsvSortOptions sortOptions) throws IOException {
        Collections.sort(tmplist, sortOptions.getComparator());
        File newtmpfile = File.createTempFile("sortInBatch", "flatfile", tmpdirectory);
        newtmpfile.deleteOnExit();
        CSVRecord lastLine = null;
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(newtmpfile), sortOptions.getCharset());
             CSVPrinter printer = new CSVPrinter((Appendable)new BufferedWriter(writer), sortOptions.getFormat());){
            for (CSVRecord r : tmplist) {
                if (sortOptions.isDistinct() && CsvExternalSort.checkDuplicateLine(r, lastLine)) continue;
                printer.printRecord((Iterable)r);
                lastLine = r;
            }
        }
        return newtmpfile;
    }

    private static boolean checkDuplicateLine(CSVRecord currentLine, CSVRecord lastLine) {
        if (lastLine == null || currentLine == null) {
            return false;
        }
        for (int i = 0; i < currentLine.size(); ++i) {
            if (currentLine.get(i).equals(lastLine.get(i))) continue;
            return false;
        }
        return true;
    }

    public static List<File> sortInBatch(File file, File tmpdirectory, CsvSortOptions sortOptions, List<CSVRecord> header) throws IOException {
        try (BufferedReader fbr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), sortOptions.getCharset()));){
            List<File> list = CsvExternalSort.sortInBatch(file.length(), fbr, tmpdirectory, sortOptions, header);
            return list;
        }
    }
}

