/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.externalsorting.csv;

public final class SizeEstimator {
    private static int OBJ_HEADER;
    private static int ARR_HEADER;
    private static int INT_FIELDS;
    private static int OBJ_REF;
    private static int OBJ_OVERHEAD;
    private static boolean IS_64_BIT_JVM;

    private SizeEstimator() {
    }

    public static long estimatedSizeOf(Object s) {
        return (long)(s.toString().length() * 2) + (long)OBJ_OVERHEAD;
    }

    static {
        INT_FIELDS = 12;
        IS_64_BIT_JVM = true;
        String arch = System.getProperty("sun.arch.data.model");
        if (arch != null && arch.indexOf("32") != -1) {
            IS_64_BIT_JVM = false;
        }
        OBJ_HEADER = IS_64_BIT_JVM ? 16 : 8;
        ARR_HEADER = IS_64_BIT_JVM ? 24 : 12;
        OBJ_REF = IS_64_BIT_JVM ? 8 : 4;
        OBJ_OVERHEAD = OBJ_HEADER + INT_FIELDS + OBJ_REF + ARR_HEADER;
    }
}

