/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import io.dropwizard.metrics5.Counter;
import io.dropwizard.metrics5.Gauge;
import io.dropwizard.metrics5.Metric;
import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.SharedMetricRegistries;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.lock.LockManager;
import org.nuxeo.ecm.core.api.repository.FulltextConfiguration;
import org.nuxeo.ecm.core.storage.FulltextDescriptor;
import org.nuxeo.ecm.core.storage.lock.LockManagerService;
import org.nuxeo.ecm.core.storage.sql.CachingMapper;
import org.nuxeo.ecm.core.storage.sql.Mapper;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.ModelSetup;
import org.nuxeo.ecm.core.storage.sql.Node;
import org.nuxeo.ecm.core.storage.sql.Repository;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.Session;
import org.nuxeo.ecm.core.storage.sql.SessionImpl;
import org.nuxeo.ecm.core.storage.sql.SoftRefCachingMapper;
import org.nuxeo.ecm.core.storage.sql.VCSClusterInvalidator;
import org.nuxeo.ecm.core.storage.sql.VCSInvalidationsPropagator;
import org.nuxeo.ecm.core.storage.sql.VCSLockManager;
import org.nuxeo.ecm.core.storage.sql.VCSPubSubInvalidator;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLSession;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCConnection;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCLogger;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCMapper;
import org.nuxeo.ecm.core.storage.sql.jdbc.SQLInfo;
import org.nuxeo.ecm.core.storage.sql.jdbc.TableUpgrader;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.DialectOracle;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.cluster.ClusterService;
import org.nuxeo.runtime.datasource.ConnectionHelper;
import org.nuxeo.runtime.datasource.DataSourceHelper;
import org.nuxeo.runtime.metrics.MetricsService;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class RepositoryImpl
implements Repository,
org.nuxeo.ecm.core.model.Repository {
    private static final Log log = LogFactory.getLog(RepositoryImpl.class);
    public static final String TEST_UPGRADE = "testUpgrade";
    public static final String TEST_UPGRADE_VERSIONS = "testUpgradeVersions";
    public static final String TEST_UPGRADE_LAST_CONTRIBUTOR = "testUpgradeLastContributor";
    public static final String TEST_UPGRADE_LOCKS = "testUpgradeLocks";
    public static final String TEST_UPGRADE_SYS_CHANGE_TOKEN = "testUpgradeSysChangeToken";
    public static Map<String, Serializable> testProps = new HashMap<String, Serializable>();
    protected final RepositoryDescriptor repositoryDescriptor;
    private final Collection<SessionImpl> sessions;
    protected final MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    protected final Counter sessionCount;
    private LockManager lockManager;
    protected boolean selfRegisteredLockManager = false;
    public final VCSInvalidationsPropagator invalidationsPropagator;
    protected VCSClusterInvalidator clusterInvalidator;
    public boolean requiresClusterSQL;
    private Model model;
    protected SQLInfo sqlInfo;

    public RepositoryImpl(RepositoryDescriptor repositoryDescriptor) {
        this.repositoryDescriptor = repositoryDescriptor;
        this.sessions = new CopyOnWriteArrayList<SessionImpl>();
        this.invalidationsPropagator = new VCSInvalidationsPropagator();
        this.sessionCount = this.registry.counter(MetricName.build((String[])new String[]{"nuxeo", "repositories", "repository", "sessions"}).tagged(new String[]{"repository", repositoryDescriptor.name}));
        this.createMetricsGauges();
        this.initRepository();
    }

    protected void createMetricsGauges() {
        MetricName gaugeName = MetricName.build((String[])new String[]{"nuxeo", "repositories", "repository", "cache", "size"}).tagged(new String[]{"repository", this.repositoryDescriptor.name});
        this.registry.remove(gaugeName);
        this.registry.register(gaugeName, (Metric)new Gauge<Long>(){

            public Long getValue() {
                return RepositoryImpl.this.getCacheSize();
            }
        });
        gaugeName = MetricName.build((String[])new String[]{"nuxeo", "repositories", "repository", "cache", "pristine"}).tagged(new String[]{"repository", this.repositoryDescriptor.name});
        this.registry.remove(gaugeName);
        this.registry.register(gaugeName, (Metric)new Gauge<Long>(){

            public Long getValue() {
                return RepositoryImpl.this.getCachePristineSize();
            }
        });
        gaugeName = MetricName.build((String[])new String[]{"nuxeo", "repositories", "repository", "cache", "selection"}).tagged(new String[]{"repository", this.repositoryDescriptor.name});
        this.registry.remove(gaugeName);
        this.registry.register(gaugeName, (Metric)new Gauge<Long>(){

            public Long getValue() {
                return RepositoryImpl.this.getCacheSelectionSize();
            }
        });
        gaugeName = MetricName.build((String[])new String[]{"nuxeo", "repositories", "repository", "cache", "mapper"}).tagged(new String[]{"repository", this.repositoryDescriptor.name});
        this.registry.remove(gaugeName);
        this.registry.register(gaugeName, (Metric)new Gauge<Long>(){

            public Long getValue() {
                return RepositoryImpl.this.getCacheMapperSize();
            }
        });
    }

    protected Mapper createCachingMapper(Model model, Mapper mapper) {
        try {
            Class<? extends CachingMapper> cachingMapperClass = this.getCachingMapperClass();
            if (cachingMapperClass == null) {
                return mapper;
            }
            CachingMapper cachingMapper = cachingMapperClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            cachingMapper.initialize(this.getName(), model, mapper, this.invalidationsPropagator, this.repositoryDescriptor.cachingMapperProperties);
            return cachingMapper;
        }
        catch (ReflectiveOperationException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    protected Class<? extends CachingMapper> getCachingMapperClass() {
        if (!this.repositoryDescriptor.getCachingMapperEnabled()) {
            return null;
        }
        Class<? extends CachingMapper> cachingMapperClass = this.repositoryDescriptor.cachingMapperClass;
        if (cachingMapperClass == null) {
            cachingMapperClass = SoftRefCachingMapper.class;
        }
        return cachingMapperClass;
    }

    public RepositoryDescriptor getRepositoryDescriptor() {
        return this.repositoryDescriptor;
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    public Model getModel() {
        return this.model;
    }

    public SQLInfo getSQLInfo() {
        return this.sqlInfo;
    }

    public VCSInvalidationsPropagator getInvalidationsPropagator() {
        return this.invalidationsPropagator;
    }

    public boolean isChangeTokenEnabled() {
        return this.repositoryDescriptor.isChangeTokenEnabled();
    }

    public SQLSession getSession() {
        return new SQLSession(this.getConnection(), this);
    }

    @Override
    public synchronized SessionImpl getConnection() {
        if (Framework.getRuntime().isShuttingDown()) {
            throw new IllegalStateException("Cannot open connection, runtime is shutting down");
        }
        SessionPathResolver pathResolver = new SessionPathResolver();
        Mapper mapper = new JDBCMapper(this.model, pathResolver, this.sqlInfo, this.clusterInvalidator, this);
        mapper = this.createCachingMapper(this.model, mapper);
        SessionImpl session = new SessionImpl(this, this.model, mapper);
        pathResolver.setSession(session);
        this.sessions.add(session);
        this.sessionCount.inc();
        return session;
    }

    protected void closeSession(SessionImpl session) {
        this.sessions.remove(session);
        this.sessionCount.dec();
    }

    protected void initRepository() {
        Dialect dialect;
        log.debug((Object)"Initializing");
        this.prepareClusterInvalidator();
        String dataSourceName = JDBCConnection.getDataSourceName(this.repositoryDescriptor.name);
        try {
            DataSourceHelper.getDataSource((String)dataSourceName);
        }
        catch (NamingException cause) {
            throw new NuxeoException("Cannot acquire datasource: " + dataSourceName, (Throwable)cause);
        }
        try (Connection connection = ConnectionHelper.getConnection((String)dataSourceName);){
            dialect = Dialect.createDialect(connection, this.repositoryDescriptor);
        }
        catch (SQLException cause) {
            throw new NuxeoException("Cannot get connection from datasource: " + dataSourceName, (Throwable)cause);
        }
        ModelSetup modelSetup = new ModelSetup();
        modelSetup.materializeFulltextSyntheticColumn = dialect.getMaterializeFulltextSyntheticColumn();
        modelSetup.supportsArrayColumns = dialect.supportsArrayColumns();
        switch (dialect.getIdType()) {
            case VARCHAR: 
            case UUID: {
                modelSetup.idType = Model.IdType.STRING;
                break;
            }
            case SEQUENCE: {
                modelSetup.idType = Model.IdType.LONG;
                break;
            }
            default: {
                throw new AssertionError((Object)dialect.getIdType().toString());
            }
        }
        modelSetup.repositoryDescriptor = this.repositoryDescriptor;
        this.model = new Model(modelSetup);
        this.sqlInfo = new SQLInfo(this.model, dialect, this.requiresClusterSQL);
        String ddlMode = this.repositoryDescriptor.getDDLMode();
        if (ddlMode == null) {
            String string = ddlMode = this.repositoryDescriptor.getNoDDL() ? "ignore" : "execute";
        }
        if (ddlMode.equals("ignore")) {
            log.info((Object)"Skipping database creation");
        } else {
            this.createDatabase(ddlMode);
        }
        if (log.isDebugEnabled()) {
            FulltextDescriptor fulltextDescriptor = this.repositoryDescriptor.getFulltextDescriptor();
            log.debug((Object)String.format("Database ready, fulltext: disabled=%b storedInBlob=%b searchDisabled=%b.", fulltextDescriptor.getFulltextDisabled(), fulltextDescriptor.getFulltextStoredInBlob(), fulltextDescriptor.getFulltextSearchDisabled()));
        }
        this.initLockManager();
        this.initClusterInvalidator();
        Class<? extends CachingMapper> cachingMapperClass = this.getCachingMapperClass();
        if (cachingMapperClass == null) {
            log.warn((Object)"VCS Mapper cache is disabled.");
        } else {
            log.info((Object)("VCS Mapper cache using: " + cachingMapperClass.getName()));
        }
        this.initRootNode();
    }

    protected void initRootNode() {
        SessionImpl session = this.getConnection();
        if (session != null) {
            session.close();
        }
    }

    protected String getLockManagerName() {
        return this.getName();
    }

    protected void initLockManager() {
        String lockManagerName = this.getLockManagerName();
        LockManagerService lockManagerService = (LockManagerService)Framework.getService(LockManagerService.class);
        this.lockManager = lockManagerService.getLockManager(lockManagerName);
        if (this.lockManager == null) {
            this.lockManager = new VCSLockManager(this);
            lockManagerService.registerLockManager(lockManagerName, this.lockManager);
            this.selfRegisteredLockManager = true;
        } else {
            this.selfRegisteredLockManager = false;
        }
        log.info((Object)("Repository " + this.getName() + " using lock manager " + this.lockManager));
    }

    protected void prepareClusterInvalidator() {
        if (((ClusterService)Framework.getService(ClusterService.class)).isEnabled()) {
            this.clusterInvalidator = this.createClusterInvalidator();
            this.requiresClusterSQL = this.clusterInvalidator.requiresClusterSQL();
        }
    }

    protected VCSClusterInvalidator createClusterInvalidator() {
        Class<? extends VCSClusterInvalidator> klass = this.repositoryDescriptor.clusterInvalidatorClass;
        if (klass == null) {
            klass = VCSPubSubInvalidator.class;
        }
        try {
            return klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    protected void initClusterInvalidator() {
        if (this.clusterInvalidator != null) {
            String nodeId = ((ClusterService)Framework.getService(ClusterService.class)).getNodeId();
            this.clusterInvalidator.initialize(nodeId, this);
        }
    }

    public void shutdown() {
        this.close();
    }

    @Override
    public synchronized void close() {
        LockManagerService lms;
        this.closeAllSessions();
        this.model = null;
        if (this.clusterInvalidator != null) {
            this.clusterInvalidator.close();
        }
        if (this.selfRegisteredLockManager && (lms = (LockManagerService)Framework.getService(LockManagerService.class)) != null) {
            lms.unregisterLockManager(this.getLockManagerName());
        }
    }

    protected synchronized void closeAllSessions() {
        for (SessionImpl session : this.sessions) {
            session.closeSession();
        }
        this.sessions.clear();
        this.sessionCount.dec(this.sessionCount.getCount());
        if (this.lockManager != null) {
            this.lockManager.closeLockManager();
        }
    }

    @Override
    public String getName() {
        return this.repositoryDescriptor.name;
    }

    @Override
    public int clearCaches() {
        int n = 0;
        for (SessionImpl session : this.sessions) {
            n += session.clearCaches();
        }
        if (this.lockManager != null) {
            this.lockManager.clearLockManagerCaches();
        }
        return n;
    }

    @Override
    public long getCacheSize() {
        long size = 0L;
        for (SessionImpl session : this.sessions) {
            size += session.getCacheSize();
        }
        return size;
    }

    public long getCacheMapperSize() {
        long size = 0L;
        for (SessionImpl session : this.sessions) {
            size += session.getCacheMapperSize();
        }
        return size;
    }

    @Override
    public long getCachePristineSize() {
        long size = 0L;
        for (SessionImpl session : this.sessions) {
            size += session.getCachePristineSize();
        }
        return size;
    }

    @Override
    public long getCacheSelectionSize() {
        long size = 0L;
        for (SessionImpl session : this.sessions) {
            size += session.getCacheSelectionSize();
        }
        return size;
    }

    @Override
    public void processClusterInvalidationsNext() {
    }

    @Override
    public void markReferencedBinaries() {
        try (SessionImpl session = this.getConnection();){
            session.markReferencedBinaries();
        }
    }

    @Override
    public int cleanupDeletedDocuments(int max, Calendar beforeTime) {
        if (!this.repositoryDescriptor.getSoftDeleteEnabled()) {
            return 0;
        }
        try (SessionImpl session = this.getConnection();){
            int n = session.cleanupDeletedDocuments(max, beforeTime);
            return n;
        }
    }

    @Override
    public FulltextConfiguration getFulltextConfiguration() {
        return this.model.getFulltextConfiguration();
    }

    protected void createDatabase(String ddlMode) {
        RepositoryImpl.runWithoutTransaction(() -> this.createDatabaseNoTx(ddlMode));
    }

    protected void createDatabaseNoTx(String ddlMode) {
        String dataSourceName = "repository_" + this.getName();
        try (Connection connection = ConnectionHelper.getConnection((String)dataSourceName, (boolean)true);){
            this.sqlInfo.dialect.performPostOpenStatements(connection);
            if (!connection.getAutoCommit()) {
                throw new NuxeoException("connection should not run in transactional mode for DDL operations");
            }
            this.createTables(connection, ddlMode);
        }
        catch (SQLException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    protected String getTableName(String origName) {
        if (this.sqlInfo.dialect instanceof DialectOracle && origName.length() > 30) {
            StringBuilder sb = new StringBuilder(origName.length());
            try {
                MessageDigest digest = MessageDigest.getInstance("MD5");
                sb.append(origName.substring(0, 15));
                sb.append('_');
                digest.update(origName.getBytes());
                sb.append(Dialect.toHexString(digest.digest()).substring(0, 12));
                return sb.toString();
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Error", e);
            }
        }
        return origName;
    }

    /*
     * Exception decompiling
     */
    protected void createTables(Connection connection, String ddlMode) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected TableUpgrader createTableUpgrader(Connection connection, JDBCLogger logger) {
        TableUpgrader tableUpgrader = new TableUpgrader(this.sqlInfo, connection, logger);
        tableUpgrader.add("versions", "islatest", "upgradeVersions", TEST_UPGRADE_VERSIONS);
        tableUpgrader.add("dublincore", "lastContributor", "upgradeLastContributor", TEST_UPGRADE_LAST_CONTRIBUTOR);
        tableUpgrader.add("locks", "owner", "upgradeLocks", TEST_UPGRADE_LOCKS);
        tableUpgrader.add("hierarchy", "systemchangetoken", "upgradeSysChangeToken", TEST_UPGRADE_SYS_CHANGE_TOKEN);
        return tableUpgrader;
    }

    protected static Set<String> findTableNames(DatabaseMetaData metadata, String schemaName) throws SQLException {
        HashSet<String> tableNames = new HashSet<String>();
        ResultSet rs = metadata.getTables(null, schemaName, "%", new String[]{"TABLE"});
        while (rs.next()) {
            String tableName = rs.getString("TABLE_NAME");
            tableNames.add(tableName.toUpperCase());
        }
        rs.close();
        return tableNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void runWithoutTransaction(Runnable runnable) {
        boolean rollback = TransactionHelper.isTransactionMarkedRollback();
        boolean hasTransaction = TransactionHelper.isTransactionActiveOrMarkedRollback();
        if (hasTransaction) {
            TransactionHelper.commitOrRollbackTransaction();
        }
        boolean completedAbruptly = true;
        try {
            runnable.run();
            completedAbruptly = false;
        }
        finally {
            if (hasTransaction) {
                try {
                    TransactionHelper.startTransaction();
                }
                finally {
                    if (completedAbruptly || rollback) {
                        TransactionHelper.setTransactionRollbackOnly();
                    }
                }
            }
        }
    }

    public static class SessionPathResolver
    implements Session.PathResolver {
        private Session session;

        protected void setSession(Session session) {
            this.session = session;
        }

        @Override
        public Serializable getIdForPath(String path) {
            Node node = this.session.getNodeByPath(path, null);
            return node == null ? null : node.getId();
        }
    }
}

