/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.bulk;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.nuxeo.elasticsearch.bulk.BulkIndexComputation;
import org.nuxeo.elasticsearch.bulk.IndexCompletionComputation;
import org.nuxeo.elasticsearch.bulk.IndexRequestComputation;
import org.nuxeo.lib.stream.computation.Topology;
import org.nuxeo.runtime.stream.StreamProcessorTopology;

public class IndexAction
implements StreamProcessorTopology {
    public static final String ACTION_NAME = "index";
    public static final String ACTION_FULL_NAME = "bulk/index";
    public static final String ES_BULK_SIZE_OPTION = "esBulkSizeBytes";
    public static final int ES_BULK_SIZE_DEFAULT = 0x500000;
    public static final String ES_BULK_ACTION_OPTION = "esBulkActions";
    public static final int ES_BULK_ACTION_DEFAULT = 1000;
    public static final String BULK_FLUSH_INTERVAL_OPTION = "flushIntervalSeconds";
    public static final int BULK_FLUSH_INTERVAL_DEFAULT = 10;
    public static final String INDEX_UPDATE_ALIAS_PARAM = "updateAlias";
    public static final String REFRESH_INDEX_PARAM = "refresh";

    public Topology getTopology(Map<String, String> options) {
        int esBulkSize = IndexAction.getOptionAsInteger(options, ES_BULK_SIZE_OPTION, 0x500000);
        int esBulkActions = IndexAction.getOptionAsInteger(options, ES_BULK_ACTION_OPTION, 1000);
        int esBulkFlushInterval = IndexAction.getOptionAsInteger(options, BULK_FLUSH_INTERVAL_OPTION, 10);
        return Topology.builder().addComputation(IndexRequestComputation::new, Arrays.asList("i1:bulk/index", "o1:bulk/bulkIndex")).addComputation(() -> new BulkIndexComputation(esBulkSize, esBulkActions, esBulkFlushInterval), Arrays.asList("i1:bulk/bulkIndex", "o1:bulk/status")).addComputation(() -> new IndexCompletionComputation(), Collections.singletonList("i1:bulk/done")).build();
    }

    public static int getOptionAsInteger(Map<String, String> options, String option, int defaultValue) {
        String value = options.get(option);
        return value == null ? defaultValue : Integer.parseInt(value);
    }
}

