/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.dbs;

import com.google.common.cache.Cache;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.PartialList;
import org.nuxeo.ecm.core.api.ScrollResult;
import org.nuxeo.ecm.core.query.sql.model.OrderByClause;
import org.nuxeo.ecm.core.storage.State;
import org.nuxeo.ecm.core.storage.dbs.DBSCachingRepository;
import org.nuxeo.ecm.core.storage.dbs.DBSClusterInvalidator;
import org.nuxeo.ecm.core.storage.dbs.DBSConnection;
import org.nuxeo.ecm.core.storage.dbs.DBSExpressionEvaluator;
import org.nuxeo.ecm.core.storage.dbs.DBSInvalidations;
import org.nuxeo.ecm.core.storage.dbs.DBSInvalidationsPropagator;
import org.nuxeo.ecm.core.storage.dbs.DBSInvalidationsQueue;
import org.nuxeo.ecm.core.storage.dbs.DBSTransactionState;

public class DBSCachingConnection
implements DBSConnection {
    protected final DBSConnection connection;
    private final Cache<String, State> cache;
    private final Cache<String, String> childCache;
    private final DBSInvalidations invalidations;
    private final DBSClusterInvalidator clusterInvalidator;
    private final DBSInvalidationsQueue invalidationsQueue;
    private final DBSInvalidationsPropagator invalidationsPropagator;

    public DBSCachingConnection(DBSConnection connection, DBSCachingRepository repository) {
        this.connection = connection;
        if (repository.supportsTransactions()) {
            this.cache = repository.newCache(false);
            this.childCache = repository.newChildCache(false);
        } else {
            this.cache = repository.getCache();
            this.childCache = repository.getChildCache();
        }
        this.invalidationsPropagator = repository.getInvalidationsPropagator();
        if (this.invalidationsPropagator == null) {
            this.invalidationsQueue = null;
        } else {
            this.invalidationsQueue = new DBSInvalidationsQueue("dbs-" + this);
            this.invalidationsPropagator.addQueue(this.invalidationsQueue);
        }
        this.clusterInvalidator = repository.getClusterInvalidator();
        this.invalidations = this.invalidationsPropagator == null && this.clusterInvalidator == null ? null : new DBSInvalidations();
    }

    @Override
    public void close() {
        this.connection.close();
        if (this.invalidationsPropagator != null) {
            this.invalidationsPropagator.removeQueue(this.invalidationsQueue);
        }
        if (this.cache != null) {
            this.cache.invalidateAll();
            this.childCache.invalidateAll();
        }
        if (this.clusterInvalidator != null) {
            this.clusterInvalidator.sendInvalidations(new DBSInvalidations(true));
        }
    }

    @Override
    public void begin() {
        this.connection.begin();
        this.processReceivedInvalidations();
    }

    @Override
    public void commit() {
        this.connection.commit();
        this.sendInvalidationsToOthers();
        this.processReceivedInvalidations();
    }

    @Override
    public void rollback() {
        this.connection.rollback();
    }

    @Override
    public State readState(String id) {
        State state = (State)this.cache.getIfPresent((Object)id);
        if (state == null && (state = this.connection.readState(id)) != null) {
            this.putInCache(state);
        }
        return state;
    }

    @Override
    public State readPartialState(String id, Collection<String> keys) {
        return this.connection.readPartialState(id, keys);
    }

    @Override
    public List<State> readStates(List<String> ids) {
        ImmutableMap statesMap = this.cache.getAllPresent(ids);
        ArrayList<String> idsToRetrieve = new ArrayList<String>(ids);
        idsToRetrieve.removeAll((Collection<?>)statesMap.keySet());
        List<State> states = this.connection.readStates(idsToRetrieve);
        states.forEach(this::putInCache);
        states.addAll((Collection<State>)statesMap.values());
        return states;
    }

    @Override
    public void createState(State state) {
        this.connection.createState(state);
    }

    @Override
    public void createStates(List<State> states) {
        this.connection.createStates(states);
    }

    @Override
    public void updateState(String id, State.StateDiff diff, DBSTransactionState.ChangeTokenUpdater changeTokenUpdater) {
        this.connection.updateState(id, diff, changeTokenUpdater);
        this.invalidate(id);
    }

    @Override
    public void deleteStates(Set<String> ids) {
        this.connection.deleteStates(ids);
        this.invalidate(ids);
    }

    @Override
    public State readChildState(String parentId, String name, Set<String> ignored) {
        State state;
        this.processReceivedInvalidations();
        String childCacheKey = this.computeChildCacheKey(parentId, name);
        String stateId = (String)this.childCache.getIfPresent((Object)childCacheKey);
        if (stateId != null && (state = (State)this.cache.getIfPresent((Object)stateId)) != null) {
            if (parentId.equals(state.get((Object)"ecm:parentId")) && name.equals(state.get((Object)"ecm:name"))) {
                return state;
            }
            this.childCache.invalidate((Object)childCacheKey);
        }
        state = this.connection.readChildState(parentId, name, ignored);
        this.putInCache(state);
        return state;
    }

    private void putInCache(State state) {
        if (state != null) {
            String stateId = state.get((Object)"ecm:id").toString();
            this.cache.put((Object)stateId, (Object)state);
            Serializable stateParentId = state.get((Object)"ecm:parentId");
            if (stateParentId != null) {
                this.childCache.put((Object)this.computeChildCacheKey(stateParentId.toString(), state.get((Object)"ecm:name").toString()), (Object)stateId);
            }
        }
    }

    private String computeChildCacheKey(String parentId, String name) {
        return parentId + "_" + name;
    }

    private void invalidate(String id) {
        this.invalidate(List.of(id));
    }

    private void invalidate(Collection<String> ids) {
        this.cache.invalidateAll(ids);
        if (this.invalidations != null) {
            this.invalidations.addAll(ids);
        }
    }

    protected void sendInvalidationsToOthers() {
        if (this.invalidations != null && !this.invalidations.isEmpty()) {
            if (this.clusterInvalidator != null) {
                this.clusterInvalidator.sendInvalidations(this.invalidations);
            }
            if (this.invalidationsPropagator != null) {
                this.invalidationsPropagator.propagateInvalidations(this.invalidations, this.invalidationsQueue);
            }
            this.invalidations.clear();
        }
    }

    protected void processReceivedInvalidations() {
        DBSInvalidations invals;
        if (this.clusterInvalidator != null) {
            invals = (DBSInvalidations)this.clusterInvalidator.receiveInvalidations();
            if (invals != null && !invals.isEmpty() && this.invalidationsPropagator != null) {
                this.invalidationsPropagator.propagateInvalidations(invals, this.invalidationsQueue);
            }
        } else {
            invals = null;
        }
        if (this.invalidationsQueue != null) {
            DBSInvalidations inv = (DBSInvalidations)this.invalidationsQueue.getInvalidations();
            if (invals == null) {
                invals = inv;
            } else {
                invals.add(inv);
            }
        }
        if (invals != null && !invals.isEmpty()) {
            if (invals.all) {
                this.cache.invalidateAll();
                this.childCache.invalidateAll();
            } else if (invals.ids != null) {
                this.cache.invalidateAll(invals.ids);
            }
        }
    }

    @Override
    public String getRootId() {
        return this.connection.getRootId();
    }

    @Override
    public String generateNewId() {
        return this.connection.generateNewId();
    }

    @Override
    public boolean hasChild(String parentId, String name, Set<String> ignored) {
        return this.connection.hasChild(parentId, name, ignored);
    }

    @Override
    public List<State> queryKeyValue(String key, Object value, Set<String> ignored) {
        return this.connection.queryKeyValue(key, value, ignored);
    }

    @Override
    public List<State> queryKeyValue(String key1, Object value1, String key2, Object value2, Set<String> ignored) {
        return this.connection.queryKeyValue(key1, value1, key2, value2, ignored);
    }

    @Override
    public Stream<State> getDescendants(String id, Set<String> keys) {
        return this.connection.getDescendants(id, keys);
    }

    @Override
    public Stream<State> getDescendants(String id, Set<String> keys, int limit) {
        return this.connection.getDescendants(id, keys, limit);
    }

    @Override
    public boolean queryKeyValuePresence(String key, String value, Set<String> ignored) {
        return this.connection.queryKeyValuePresence(key, value, ignored);
    }

    @Override
    public PartialList<Map<String, Serializable>> queryAndFetch(DBSExpressionEvaluator evaluator, OrderByClause orderByClause, boolean distinctDocuments, int limit, int offset, int countUpTo) {
        return this.connection.queryAndFetch(evaluator, orderByClause, distinctDocuments, limit, offset, countUpTo);
    }

    @Override
    public ScrollResult<String> scroll(DBSExpressionEvaluator evaluator, int batchSize, int keepAliveSeconds) {
        return this.connection.scroll(evaluator, batchSize, keepAliveSeconds);
    }

    @Override
    public ScrollResult<String> scroll(String scrollId) {
        return this.connection.scroll(scrollId);
    }

    public Lock getLock(String id) {
        return this.connection.getLock(id);
    }

    public Lock setLock(String id, Lock lock) {
        return this.connection.setLock(id, lock);
    }

    public Lock removeLock(String id, String owner) {
        return this.connection.removeLock(id, owner);
    }

    @Override
    public List<State> queryKeyValueWithOperator(String key1, Object value1, String key2, DBSConnection.DBSQueryOperator operator, Object value2, Set<String> ignored) {
        return this.connection.queryKeyValueWithOperator(key1, value1, key2, operator, value2, ignored);
    }
}

