/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.extension;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.nuxeo.common.Environment;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.api.NuxeoException;

@XObject(value="configuration")
public class GlobalConfigDescriptor {
    public static final boolean DEFAULT_CACHE_ENABLED = true;
    public static final long DEFAULT_GC_INTERVAL_IN_MIN = 10L;
    public static final int DEFAULT_DISK_CACHE_IN_KB = 10240;
    public static final String DEFAULT_CACHING_DIRECTORY = "convertcache";
    @XNode(value="enableCache")
    protected Boolean enableCache;
    @XNode(value="cachingDirectory")
    protected String cachingDirectory;
    protected Long GCInterval;
    protected Integer diskCacheSize;

    public boolean isCacheEnabled() {
        return this.enableCache == null ? true : this.enableCache;
    }

    public String getCachingDirectory() {
        return this.cachingDirectory == null ? this.getDefaultCachingDirectory() : this.cachingDirectory;
    }

    protected String getDefaultCachingDirectory() {
        File cache = new File(Environment.getDefault().getData(), DEFAULT_CACHING_DIRECTORY);
        return cache.getAbsolutePath();
    }

    public void clearCachingDirectory() {
        File cache = new File(this.getCachingDirectory());
        if (cache.exists()) {
            try {
                FileUtils.deleteDirectory((File)cache);
            }
            catch (IOException e) {
                throw new NuxeoException("Cannot create cache dir " + cache, (Throwable)e);
            }
        }
        cache.mkdirs();
    }

    @XNode(value="gcInterval")
    public void setGCInterval(long value) {
        this.GCInterval = value == 0L ? null : Long.valueOf(value);
    }

    public long getGCInterval() {
        return this.GCInterval == null ? 10L : this.GCInterval;
    }

    @XNode(value="diskCacheSize")
    public void setDiskCacheSize(int size) {
        this.diskCacheSize = size == 0 ? null : Integer.valueOf(size);
    }

    public int getDiskCacheSize() {
        return this.diskCacheSize == null ? 10240 : this.diskCacheSize;
    }

    public void update(GlobalConfigDescriptor other) {
        if (other.enableCache != null) {
            this.enableCache = other.enableCache;
        }
        if (other.GCInterval != null) {
            this.GCInterval = other.GCInterval;
        }
        if (other.diskCacheSize != null) {
            this.diskCacheSize = other.diskCacheSize;
        }
        if (other.cachingDirectory != null) {
            this.cachingDirectory = other.cachingDirectory;
        }
    }
}

