/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.MethodWriterBuilder;
import net.openhft.chronicle.bytes.MethodWriterInterceptor;
import net.openhft.chronicle.bytes.MethodWriterInterceptorReturns;
import net.openhft.chronicle.bytes.MethodWriterInvocationHandler;
import net.openhft.chronicle.bytes.MethodWriterListener;
import net.openhft.chronicle.bytes.UpdateInterceptor;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.wire.GenerateMethodWriter;
import net.openhft.chronicle.wire.MarshallableOut;
import net.openhft.chronicle.wire.MethodWriterInvocationHandlerSupplier;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaMethodWriterBuilder<T>
implements Supplier<T>,
MethodWriterBuilder<T> {
    private static final Class<?> COMPILE_FAILED = ClassNotFoundException.class;
    private static final Map<String, Class> classCache = new ConcurrentHashMap<String, Class>();
    private final boolean DISABLE_PROXY_GEN = Jvm.getBoolean((String)"disableProxyCodegen", (boolean)false);
    private final Set<Class> interfaces = Collections.synchronizedSet(new LinkedHashSet());
    private final String packageName;
    private ClassLoader classLoader;
    @NotNull
    private final MethodWriterInvocationHandlerSupplier<T> handlerSupplier;
    private Supplier<MarshallableOut> outSupplier;
    private Closeable closeable;
    private String genericEvent;
    private MethodWriterListener methodWriterListener;
    private boolean metaData;
    private boolean useMethodIds;
    private WireType wireType;
    private Class<?> proxyClass;
    private UpdateInterceptor updateInterceptor;

    @NotNull
    public MethodWriterBuilder<T> classLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    @NotNull
    public MethodWriterBuilder<T> updateInterceptor(UpdateInterceptor updateInterceptor) {
        this.updateInterceptor = updateInterceptor;
        return this;
    }

    @NotNull
    public MethodWriterBuilder<T> addInterface(Class additionalClass) {
        if (this.interfaces.contains(additionalClass)) {
            return this;
        }
        this.interfaces.add(additionalClass);
        for (Method method : additionalClass.getMethods()) {
            Class<?> returnType = method.getReturnType();
            if (!returnType.isInterface() || Jvm.dontChain(returnType)) continue;
            this.addInterface(returnType);
        }
        return this;
    }

    @Deprecated
    @NotNull
    public MethodWriterBuilder<T> recordHistory(boolean recordHistory) {
        this.handlerSupplier.recordHistory(recordHistory);
        return this;
    }

    public VanillaMethodWriterBuilder(@NotNull Class<T> tClass, WireType wireType, @NotNull Supplier<MethodWriterInvocationHandler> handlerSupplier) {
        this.packageName = tClass.getPackage().getName();
        this.wireType = wireType;
        this.addInterface(tClass);
        this.classLoader = tClass.getClassLoader();
        this.handlerSupplier = new MethodWriterInvocationHandlerSupplier(handlerSupplier);
    }

    @NotNull
    public MethodWriterBuilder<T> methodWriterInterceptor(MethodWriterInterceptor methodWriterInterceptor) {
        this.handlerSupplier.methodWriterInterceptor(methodWriterInterceptor);
        return this;
    }

    @NotNull
    public MethodWriterBuilder<T> methodWriterInterceptorReturns(MethodWriterInterceptorReturns methodWriterInterceptor) {
        this.handlerSupplier.methodWriterInterceptorReturns(methodWriterInterceptor);
        return this;
    }

    @NotNull
    public MethodWriterBuilder<T> methodWriterListener(MethodWriterListener methodWriterListener) {
        this.methodWriterListener = methodWriterListener;
        this.handlerSupplier.methodWriterListener(methodWriterListener);
        return this;
    }

    @NotNull
    public MethodWriterBuilder<T> disableThreadSafe(boolean theadSafe) {
        this.handlerSupplier.disableThreadSafe(theadSafe);
        return this;
    }

    @NotNull
    public T build() {
        return this.get();
    }

    @NotNull
    public MethodWriterBuilder<T> onClose(Closeable closeable) {
        this.closeable = closeable;
        this.handlerSupplier.onClose(closeable);
        return this;
    }

    public WireType wireType() {
        return this.wireType;
    }

    public VanillaMethodWriterBuilder<T> wireType(WireType wireType) {
        this.wireType = wireType;
        return this;
    }

    @NotNull
    private String getClassName() {
        StringBuilder sb = new StringBuilder();
        this.interfaces.forEach(i -> sb.append(i.getSimpleName()));
        sb.append(this.genericEvent == null ? "" : this.genericEvent);
        sb.append(this.metaData ? "MetadataAware" : "");
        sb.append(this.useMethodIds ? "MethodIds" : "");
        sb.append(this.updateInterceptor != null ? "Intercepting" : "");
        sb.append(this.hasMethodWriterListener() ? "MethodListener" : "");
        sb.append(this.toFirstCapCase(this.wireType().toString().replace("_", "")));
        sb.append("MethodWriter");
        return sb.toString();
    }

    @Override
    @NotNull
    public T get() {
        T t;
        block4: {
            if (this.proxyClass != null) {
                try {
                    Constructor<?> constructor = this.proxyClass.getConstructor(MethodWriterInvocationHandlerSupplier.class);
                    return (T)constructor.newInstance(this.handlerSupplier);
                }
                catch (Throwable e) {
                    if (!Jvm.isDebug()) break block4;
                    Jvm.debug().on(this.getClass(), e);
                }
            }
        }
        if (!this.DISABLE_PROXY_GEN && this.handlerSupplier.methodWriterInterceptorReturns() == null && (t = this.createInstance()) != null) {
            return t;
        }
        @NotNull Class[] interfacesArr = this.interfaces.toArray(new Class[this.interfaces.size()]);
        return (T)Proxy.newProxyInstance(this.classLoader, interfacesArr, (InvocationHandler)new CallSupplierInvocationHandler());
    }

    @Nullable
    private T createInstance() {
        block5: {
            String fullClassName = this.packageName + "." + this.getClassName();
            try {
                try {
                    return (T)this.newInstance(Class.forName(fullClassName));
                }
                catch (ClassNotFoundException e) {
                    Class clazz = classCache.computeIfAbsent(fullClassName, this::newClass);
                    if (clazz != null && clazz != COMPILE_FAILED) {
                        return (T)this.newInstance(clazz);
                    }
                }
            }
            catch (Throwable e) {
                classCache.put(fullClassName, COMPILE_FAILED);
                if (!Jvm.isDebug()) break block5;
                Jvm.debug().on(this.getClass(), e);
            }
        }
        return null;
    }

    private Class newClass(String fullClassName) {
        return GenerateMethodWriter.newClass(fullClassName, this.interfaces, this.classLoader, this.wireType, this.genericEvent, this.hasMethodWriterListener(), this.metaData, this.useMethodIds, this.updateInterceptor != null);
    }

    private boolean hasMethodWriterListener() {
        return this.methodWriterListener != null;
    }

    private Object newInstance(Class aClass) {
        try {
            if (this.outSupplier == null) {
                throw new NullPointerException("marshallableOut(out) has not been set.");
            }
            if (this.outSupplier.get().recordHistory()) {
                this.recordHistory(true);
                this.handlerSupplier.recordHistory(true);
            }
            return aClass.getDeclaredConstructors()[0].newInstance(this.outSupplier, this.closeable, this.methodWriterListener, this.updateInterceptor);
        }
        catch (Exception e) {
            throw Jvm.rethrow((Throwable)e);
        }
    }

    public MethodWriterBuilder<T> genericEvent(String genericEvent) {
        this.handlerSupplier.genericEvent(genericEvent);
        this.genericEvent = genericEvent;
        return this;
    }

    public MethodWriterBuilder<T> useMethodIds(boolean useMethodIds) {
        this.handlerSupplier.useMethodIds(useMethodIds);
        this.useMethodIds = useMethodIds;
        return this;
    }

    public MethodWriterBuilder<T> marshallableOut(@NotNull MarshallableOut out) {
        this.outSupplier = () -> out;
        return this;
    }

    public MethodWriterBuilder<T> marshallableOutSupplier(@NotNull Supplier<MarshallableOut> out) {
        this.outSupplier = out;
        return this;
    }

    public MethodWriterBuilder<T> metaData(boolean metaData) {
        this.metaData = metaData;
        return this;
    }

    public Class<?> proxyClass() {
        return this.proxyClass;
    }

    public MethodWriterBuilder<T> proxyClass(Class<?> proxyClass) {
        if (proxyClass.isInterface()) {
            throw new IllegalArgumentException("expecting a class rather than an interface, proxyClass=" + proxyClass);
        }
        this.proxyClass = proxyClass;
        return this;
    }

    @NotNull
    private String toFirstCapCase(@NotNull String name) {
        return Character.toUpperCase(name.charAt(0)) + name.substring(1).toLowerCase();
    }

    class CallSupplierInvocationHandler
    implements InvocationHandler {
        CallSupplierInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return VanillaMethodWriterBuilder.this.handlerSupplier.get().invoke(proxy, method, args);
        }
    }
}

