/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work;

import java.time.Duration;
import java.util.EnumSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.utils.DurationUtils;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.computation.RecordFilter;
import org.nuxeo.lib.stream.log.LogOffset;

public abstract class BaseOverflowRecordFilter
implements RecordFilter {
    private static final Logger log = LogManager.getLogger(BaseOverflowRecordFilter.class);
    public static final String STORE_NAME_OPTION = "storeName";
    public static final String DEFAULT_STORE_NAME = "default";
    public static final String STORE_TTL_OPTION = "storeTTL";
    public static final String DEFAULT_STORE_TTL = "1h";
    public static final String THRESHOLD_SIZE_OPTION = "thresholdSize";
    public static final int DEFAULT_THRESHOLD_SIZE = 1000000;
    public static final String PREFIX_OPTION = "prefix";
    public static final String DEFAULT_PREFIX = "bigRecord:";
    protected String prefix;
    protected int thresholdSize;
    protected Duration storeTTL;
    protected String storeName;

    protected abstract void storeValue(String var1, byte[] var2);

    protected abstract byte[] fetchValue(String var1);

    public void init(Map<String, String> options) {
        this.storeName = options.getOrDefault(STORE_NAME_OPTION, DEFAULT_STORE_NAME);
        this.prefix = options.getOrDefault(PREFIX_OPTION, DEFAULT_PREFIX);
        this.thresholdSize = this.parseIntOrDefault(options.get(THRESHOLD_SIZE_OPTION), 1000000);
        this.storeTTL = DurationUtils.parse((String)options.getOrDefault(STORE_TTL_OPTION, DEFAULT_STORE_TTL));
    }

    protected int parseIntOrDefault(String valueAsString, int defaultValue) {
        if (StringUtils.isEmpty((CharSequence)valueAsString)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(valueAsString);
        }
        catch (NumberFormatException e) {
            log.error("Invalid number for RecordFilter option: " + valueAsString, (Throwable)e);
            return defaultValue;
        }
    }

    public Record beforeAppend(Record record) {
        if (record.getData().length <= this.getThresholdSize()) {
            return record;
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Record: %s overflow value of size: %d", record.getKey(), record.getData().length));
        }
        EnumSet<Record.Flag> flags = EnumSet.copyOf(record.getFlags());
        flags.add(Record.Flag.EXTERNAL_VALUE);
        this.storeValue(this.getUniqRecordKey(record), record.getData());
        return new Record(record.getKey(), null, record.getWatermark(), flags);
    }

    protected String getUniqRecordKey(Record record) {
        return String.format("%s:%d", record.getKey(), record.getWatermark());
    }

    public Record afterRead(Record record, LogOffset offset) {
        if (record.getFlags().contains(Record.Flag.EXTERNAL_VALUE) && record.getData().length == 0) {
            byte[] value = this.fetchValue(this.getUniqRecordKey(record));
            if (log.isDebugEnabled()) {
                log.debug(String.format("Record: %s retrieve value of size: %d", record.getKey(), record.getData().length));
            }
            if (value == null || value.length == 0) {
                log.error(String.format("Record %s offset %s value not found, the record is lost, skipping", record.toString(), offset));
                return null;
            }
            EnumSet flags = record.getFlags();
            flags.remove(Record.Flag.EXTERNAL_VALUE);
            return new Record(record.getKey(), value, record.getWatermark(), flags);
        }
        return record;
    }

    public int getThresholdSize() {
        return this.thresholdSize;
    }

    public void setThresholdSize(int thresholdSize) {
        this.thresholdSize = thresholdSize;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public Duration getStoreTTL() {
        return this.storeTTL;
    }

    public void setStoreTTL(Duration storeTTL) {
        this.storeTTL = storeTTL;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    protected String getPrefixedKey(String recordKey) {
        return this.getPrefix() + recordKey;
    }
}

