/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema;

import org.nuxeo.ecm.core.schema.DocumentTypeDescriptor;
import org.nuxeo.ecm.core.schema.FacetDescriptor;
import org.nuxeo.ecm.core.schema.PropertyCharacteristicHandler;
import org.nuxeo.ecm.core.schema.PropertyDeprecationDescriptor;
import org.nuxeo.ecm.core.schema.PropertyDescriptor;
import org.nuxeo.ecm.core.schema.ProxiesDescriptor;
import org.nuxeo.ecm.core.schema.SchemaBindingDescriptor;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.SchemaManagerImpl;
import org.nuxeo.ecm.core.schema.TypeConfiguration;
import org.nuxeo.ecm.core.schema.TypeProvider;
import org.nuxeo.runtime.RuntimeMessage;
import org.nuxeo.runtime.RuntimeServiceException;
import org.nuxeo.runtime.logging.DeprecationLogger;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class TypeService
extends DefaultComponent {
    private static final String XP_SCHEMA = "schema";
    private static final String XP_DOCTYPE = "doctype";
    private static final String XP_CONFIGURATION = "configuration";
    private static final String XP_DEPRECATION = "deprecation";
    private SchemaManagerImpl schemaManager;

    public void activate(ComponentContext context) {
        super.activate(context);
        this.schemaManager = new SchemaManagerImpl();
    }

    public void deactivate(ComponentContext context) {
        super.deactivate(context);
        this.schemaManager = null;
    }

    public void registerContribution(Object contribution, String xp, ComponentInstance component) {
        switch (xp) {
            case "doctype": {
                if (contribution instanceof DocumentTypeDescriptor) {
                    this.schemaManager.registerDocumentType((DocumentTypeDescriptor)contribution);
                    break;
                }
                if (contribution instanceof FacetDescriptor) {
                    this.schemaManager.registerFacet((FacetDescriptor)contribution);
                    break;
                }
                if (!(contribution instanceof ProxiesDescriptor)) break;
                this.schemaManager.registerProxies((ProxiesDescriptor)contribution);
                break;
            }
            case "schema": {
                if (contribution instanceof SchemaBindingDescriptor) {
                    SchemaBindingDescriptor sbd = (SchemaBindingDescriptor)contribution;
                    sbd.context = component.getContext();
                    this.schemaManager.registerSchema(sbd);
                    break;
                }
                if (!(contribution instanceof PropertyDescriptor)) break;
                xp = this.computeSchemaExtensionPoint(contribution.getClass());
                super.registerContribution(contribution, xp, component);
                break;
            }
            case "configuration": {
                this.schemaManager.registerConfiguration((TypeConfiguration)contribution);
                break;
            }
            case "deprecation": {
                xp = this.computeSchemaExtensionPoint(PropertyDescriptor.class);
                PropertyDescriptor contrib = ((PropertyDeprecationDescriptor)contribution).toPropertyDescriptor();
                super.registerContribution((Object)contrib, xp, component);
                ComponentName compName = component.getName();
                String message = String.format("Deprecation contribution on component: %s should now be contributed to extension point: %s ", compName, XP_SCHEMA);
                DeprecationLogger.log((String)message, (String)"11.1");
                this.addRuntimeMessage(RuntimeMessage.Level.WARNING, message, RuntimeMessage.Source.EXTENSION, compName.getName());
                break;
            }
            default: {
                throw new RuntimeServiceException("Unknown extension point: " + xp);
            }
        }
    }

    public void unregisterContribution(Object contribution, String xp, ComponentInstance component) {
        switch (xp) {
            case "doctype": {
                if (contribution instanceof DocumentTypeDescriptor) {
                    this.schemaManager.unregisterDocumentType((DocumentTypeDescriptor)contribution);
                    break;
                }
                if (contribution instanceof FacetDescriptor) {
                    this.schemaManager.unregisterFacet((FacetDescriptor)contribution);
                    break;
                }
                if (!(contribution instanceof ProxiesDescriptor)) break;
                this.schemaManager.unregisterProxies((ProxiesDescriptor)contribution);
                break;
            }
            case "schema": {
                if (contribution instanceof SchemaBindingDescriptor) {
                    this.schemaManager.unregisterSchema((SchemaBindingDescriptor)contribution);
                    break;
                }
                if (!(contribution instanceof PropertyDescriptor)) break;
                xp = this.computeSchemaExtensionPoint(contribution.getClass());
                super.unregisterContribution(contribution, xp, component);
                break;
            }
            case "configuration": {
                this.schemaManager.unregisterConfiguration((TypeConfiguration)contribution);
                break;
            }
            case "deprecation": {
                xp = this.computeSchemaExtensionPoint(PropertyDescriptor.class);
                PropertyDescriptor contrib = ((PropertyDeprecationDescriptor)contribution).toPropertyDescriptor();
                super.unregisterContribution((Object)contrib, xp, component);
                break;
            }
            default: {
                throw new RuntimeServiceException("Unknown extension point: " + xp);
            }
        }
    }

    protected String computeSchemaExtensionPoint(Class<?> klass) {
        return String.format("%s-%s", XP_SCHEMA, klass.getSimpleName());
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (SchemaManager.class.isAssignableFrom(adapter) || PropertyCharacteristicHandler.class.isAssignableFrom(adapter) || TypeProvider.class.isAssignableFrom(adapter)) {
            return (T)this.schemaManager;
        }
        return null;
    }

    public void start(ComponentContext context) {
        this.schemaManager.registerPropertyCharacteristics(this.getDescriptors(this.computeSchemaExtensionPoint(PropertyDescriptor.class)));
        this.schemaManager.flushPendingsRegistration();
    }

    public void stop(ComponentContext context) {
        this.schemaManager.clearPropertyCharacteristics();
    }

    public int getApplicationStartedOrder() {
        return -100;
    }
}

