/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update;

import org.nuxeo.connect.update.Version;

public class PackageVersionRange {
    public static final PackageVersionRange ANY = new PackageVersionRange((Version)null);
    protected Version minVersion;
    protected Version maxVersion;

    public PackageVersionRange(String expr) {
        if (expr != null && expr.length() > 0) {
            int p = expr.indexOf(58);
            if (p == -1) {
                this.minVersion = new Version(expr);
            } else {
                this.minVersion = new Version(expr.substring(0, p));
                this.maxVersion = new Version(expr.substring(p + 1));
            }
        }
    }

    public PackageVersionRange(Version minVersion) {
        this.minVersion = minVersion;
    }

    public PackageVersionRange(Version minVersion, Version maxVersion) {
        this.minVersion = minVersion == null && maxVersion != null ? Version.ZERO : minVersion;
        this.maxVersion = maxVersion;
    }

    public void setMinVersion(Version minVersion) {
        this.minVersion = minVersion;
    }

    public Version getMinVersion() {
        return this.minVersion;
    }

    public void setMaxVersion(Version maxVersion) {
        this.maxVersion = maxVersion;
    }

    public Version getMaxVersion() {
        return this.maxVersion;
    }

    public boolean matchVersion(Version version) {
        if (this.minVersion == null && this.maxVersion == null) {
            return true;
        }
        if (this.minVersion != null) {
            if (this.maxVersion != null) {
                return version.greaterOrEqualThan(this.minVersion) && version.lessOrEqualsThan(this.maxVersion);
            }
            return version.greaterOrEqualThan(this.minVersion);
        }
        return version.lessOrEqualsThan(this.maxVersion);
    }

    public String toString() {
        if (this.minVersion == null && this.maxVersion == null) {
            return "";
        }
        if (this.minVersion != null) {
            if (this.maxVersion != null) {
                return this.minVersion.toString() + ':' + this.maxVersion.toString();
            }
            return this.minVersion.toString();
        }
        return Version.ZERO.toString() + ':' + this.maxVersion.toString();
    }

    public boolean matchVersionRange(PackageVersionRange versionRange) {
        Version oMinVersion = versionRange.getMinVersion();
        Version oMaxVersion = versionRange.getMaxVersion();
        return this.minVersion == null && this.maxVersion == null || this.minVersion != null && versionRange.matchVersion(this.minVersion) || this.maxVersion != null && versionRange.matchVersion(this.maxVersion) || oMinVersion != null && this.matchVersion(oMinVersion) || oMaxVersion != null && this.matchVersion(oMaxVersion);
    }
}

