/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.computedgroups;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.query.sql.model.QueryBuilder;
import org.nuxeo.ecm.platform.computedgroups.ComputedGroupsService;
import org.nuxeo.ecm.platform.computedgroups.GroupComputer;
import org.nuxeo.ecm.platform.computedgroups.GroupComputerChainDescriptor;
import org.nuxeo.ecm.platform.computedgroups.GroupComputerDescriptor;
import org.nuxeo.ecm.platform.computedgroups.GroupComputerLabelled;
import org.nuxeo.ecm.platform.computedgroups.NuxeoComputedGroup;
import org.nuxeo.ecm.platform.usermanager.GroupConfig;
import org.nuxeo.ecm.platform.usermanager.NuxeoPrincipalImpl;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class ComputedGroupsServiceImpl
extends DefaultComponent
implements ComputedGroupsService {
    public static final String COMPUTER_EP = "computer";
    public static final String CHAIN_EP = "computerChain";
    protected Map<String, GroupComputerDescriptor> computers = new HashMap<String, GroupComputerDescriptor>();
    protected List<String> computerNames = new ArrayList<String>();
    protected boolean allowOverride = true;
    protected static Log log = LogFactory.getLog(ComputedGroupsServiceImpl.class);

    public void activate(ComponentContext context) {
        super.activate(context);
        this.computers.clear();
        this.computerNames.clear();
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (COMPUTER_EP.equals(extensionPoint)) {
            if (contribution instanceof GroupComputerDescriptor) {
                GroupComputerDescriptor desc = (GroupComputerDescriptor)contribution;
                if (desc.isEnabled()) {
                    log.debug((Object)("Add " + desc.getName() + " from component " + contributor.getName()));
                    this.computers.put(desc.getName(), desc);
                } else if (this.computers.containsKey(desc.getName())) {
                    log.debug((Object)("Remove " + desc.getName() + " from component " + contributor.getName()));
                    this.computers.remove(desc.getName());
                } else {
                    log.warn((Object)("Can't remove " + desc.getName() + " as not found, from component " + contributor.getName()));
                }
                return;
            }
            throw new RuntimeException("Waiting GroupComputerDescriptor contribution kind, please look component " + contributor.getName());
        }
        if (CHAIN_EP.equals(extensionPoint)) {
            GroupComputerChainDescriptor desc = (GroupComputerChainDescriptor)contribution;
            if (desc.isAppend()) {
                this.computerNames.addAll(desc.getComputerNames());
            } else {
                this.computerNames = desc.getComputerNames();
            }
            return;
        }
        log.warn((Object)("Unkown contribution, please check the component " + contributor.getName()));
    }

    @Override
    public List<String> computeGroupsForUser(NuxeoPrincipalImpl nuxeoPrincipal) {
        ArrayList<String> userGroups = new ArrayList<String>();
        for (String computerName : this.computerNames) {
            userGroups.addAll(this.computers.get(computerName).getComputer().getGroupsForUser(nuxeoPrincipal));
        }
        return userGroups;
    }

    @Override
    public void updateGroupsForUser(NuxeoPrincipalImpl nuxeoPrincipal) {
        List<String> computedGroups = this.computeGroupsForUser(nuxeoPrincipal);
        HashSet<String> virtualGroups = new HashSet<String>(nuxeoPrincipal.getVirtualGroups());
        virtualGroups.addAll(computedGroups);
        nuxeoPrincipal.setVirtualGroups(new ArrayList<String>(virtualGroups));
    }

    @Override
    public boolean allowGroupOverride() {
        return this.allowOverride;
    }

    @Override
    @Deprecated
    public NuxeoGroup getComputedGroup(String groupName) {
        return this.getComputedGroup(groupName, GroupConfig.DEFAULT);
    }

    @Override
    public NuxeoGroup getComputedGroup(String groupName, GroupConfig groupConfig) {
        for (String name : this.computerNames) {
            GroupComputer computer = this.computers.get(name).getComputer();
            if (!computer.hasGroup(groupName)) continue;
            if (computer instanceof GroupComputerLabelled) {
                String groupLabel = ((GroupComputerLabelled)computer).getLabel(groupName);
                return new NuxeoComputedGroup(groupName, groupLabel, groupConfig);
            }
            return new NuxeoComputedGroup(groupName, groupConfig);
        }
        return null;
    }

    @Override
    public List<String> computeGroupIds() {
        ArrayList<String> groupIds = new ArrayList<String>();
        for (String name : this.computerNames) {
            GroupComputerDescriptor desc = this.computers.get(name);
            List<String> foundGroupIds = desc.getComputer().getAllGroupIds();
            if (foundGroupIds == null) continue;
            groupIds.addAll(foundGroupIds);
        }
        return groupIds;
    }

    @Override
    public List<String> getComputedGroupMembers(String groupName) {
        ArrayList<String> members = new ArrayList<String>();
        for (String name : this.computerNames) {
            GroupComputerDescriptor desc = this.computers.get(name);
            List<String> foundMembers = desc.getComputer().getGroupMembers(groupName);
            if (foundMembers == null) continue;
            members.addAll(foundMembers);
        }
        return members;
    }

    @Override
    public List<String> getComputedGroupParent(String groupName) {
        ArrayList<String> parents = new ArrayList<String>();
        for (String name : this.computerNames) {
            GroupComputerDescriptor desc = this.computers.get(name);
            List<String> foundParents = desc.getComputer().getParentsGroupNames(groupName);
            if (foundParents == null) continue;
            parents.addAll(foundParents);
        }
        return parents;
    }

    @Override
    public List<String> getComputedGroupSubGroups(String groupName) {
        ArrayList<String> subGroups = new ArrayList<String>();
        for (String name : this.computerNames) {
            GroupComputerDescriptor desc = this.computers.get(name);
            List<String> foundSubGroups = desc.getComputer().getSubGroupsNames(groupName);
            if (foundSubGroups == null) continue;
            subGroups.addAll(foundSubGroups);
        }
        return subGroups;
    }

    public List<GroupComputerDescriptor> getComputerDescriptors() {
        ArrayList<GroupComputerDescriptor> result = new ArrayList<GroupComputerDescriptor>();
        for (String name : this.computerNames) {
            result.add(this.computers.get(name));
        }
        return result;
    }

    @Override
    public boolean activateComputedGroups() {
        return this.computerNames.size() > 0;
    }

    @Override
    public List<String> searchComputedGroups(Map<String, Serializable> filter, Set<String> fulltext) {
        ArrayList<String> foundGroups = new ArrayList<String>();
        for (String name : this.computerNames) {
            GroupComputerDescriptor desc = this.computers.get(name);
            foundGroups.addAll(desc.getComputer().searchGroups(filter, fulltext));
        }
        Collections.sort(foundGroups);
        return foundGroups;
    }

    @Override
    public List<String> searchComputedGroups(QueryBuilder queryBuilder) {
        ArrayList<String> groups = new ArrayList<String>();
        for (String name : this.computerNames) {
            GroupComputerDescriptor desc = this.computers.get(name);
            groups.addAll(desc.getComputer().searchGroups(queryBuilder));
        }
        Collections.sort(groups);
        return groups;
    }

    public void deactivate(ComponentContext context) {
        super.deactivate(context);
    }
}

