/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.config.backingservices;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.codec.CryptoProperties;
import org.nuxeo.launcher.commons.DatabaseDriverException;
import org.nuxeo.launcher.config.ConfigurationException;
import org.nuxeo.launcher.config.ConfigurationGenerator;
import org.nuxeo.launcher.config.backingservices.BackingChecker;

public class DBCheck
implements BackingChecker {
    private static final Log log = LogFactory.getLog(DBCheck.class);
    public static final List<String> DB_EXCLUDE_CHECK_LIST = Arrays.asList("default", "none");

    @Override
    public boolean accepts(ConfigurationGenerator cg) {
        return !DB_EXCLUDE_CHECK_LIST.contains(cg.getUserConfig().getProperty("nuxeo.db.type"));
    }

    @Override
    public void check(ConfigurationGenerator cg) throws ConfigurationException {
        try {
            this.checkDatabaseConnection(cg);
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
        catch (DatabaseDriverException e) {
            log.debug((Object)e, (Throwable)e);
            log.error((Object)e.getMessage());
            throw new ConfigurationException("Could not find database driver: " + e.getMessage());
        }
        catch (SQLException e) {
            log.debug((Object)e, (Throwable)e);
            log.error((Object)e.getMessage());
            throw new ConfigurationException("Failed to connect on database: " + e.getMessage());
        }
    }

    public void checkDatabaseConnection(ConfigurationGenerator cg) throws FileNotFoundException, IOException, DatabaseDriverException, SQLException {
        CryptoProperties config = cg.getUserConfig();
        String databaseTemplate = config.getProperty("nuxeo.dbtemplate");
        String dbName = config.getProperty("nuxeo.db.name");
        String dbUser = config.getProperty("nuxeo.db.user");
        String dbPassword = config.getProperty("nuxeo.db.password");
        String dbHost = config.getProperty("nuxeo.db.host");
        String dbPort = config.getProperty("nuxeo.db.port");
        cg.checkDatabaseConnection(databaseTemplate, dbName, dbUser, dbPassword, dbHost, dbPort);
    }
}

