/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.api.adapters;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.DocumentBlobHolder;
import org.nuxeo.ecm.platform.picture.api.adapters.PictureResourceAdapter;

public class PictureBookBlobHolder
extends DocumentBlobHolder {
    private CoreSession session;

    public PictureBookBlobHolder(DocumentModel doc, String xPath) {
        super(doc, xPath);
    }

    public Blob getBlob() {
        DocumentModelList docs;
        CoreSession session = this.getSession();
        if (session == null) {
            session = CoreInstance.getCoreSession((String)this.doc.getRepositoryName());
        }
        if ((docs = session.getChildren(this.doc.getRef(), "Picture")).isEmpty()) {
            return null;
        }
        DocumentModel documentModel = (DocumentModel)docs.get(0);
        if (documentModel == null) {
            return null;
        }
        BlobHolder bh = (BlobHolder)documentModel.getAdapter(BlobHolder.class);
        return bh.getBlob();
    }

    public List<Blob> getBlobs() {
        return this.getBlobs("Original");
    }

    public List<Blob> getBlobs(String title) {
        CoreSession session = this.getSession();
        if (session == null) {
            session = CoreInstance.getCoreSession((String)this.doc.getRepositoryName());
        }
        DocumentModelList docList = session.getChildren(this.doc.getRef(), "Picture");
        ArrayList<Blob> blobList = new ArrayList<Blob>(docList.size());
        for (DocumentModel documentModel : docList) {
            if ("Original".equals(title)) {
                BlobHolder bh = (BlobHolder)documentModel.getAdapter(BlobHolder.class);
                blobList.add(bh.getBlob());
                continue;
            }
            PictureResourceAdapter picture = (PictureResourceAdapter)documentModel.getAdapter(PictureResourceAdapter.class);
            blobList.add(picture.getPictureFromTitle(title));
        }
        return blobList;
    }

    public String getHash() {
        String h;
        Blob blob = this.getBlob();
        if (blob != null && (h = blob.getDigest()) != null) {
            return h;
        }
        return this.doc.getId() + this.xPath + this.getModificationDate().toString();
    }

    protected CoreSession getSession() {
        if (this.session == null && this.doc != null) {
            this.session = this.doc.getCoreSession();
        }
        return this.session;
    }
}

