/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.tools.command;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.nuxeo.lib.stream.computation.Topology;
import org.nuxeo.lib.stream.log.LogManager;
import org.nuxeo.lib.stream.tools.command.LatencyDatadogComputation;
import org.nuxeo.lib.stream.tools.command.MonitorCommand;

public class DatadogCommand
extends MonitorCommand {
    public static final String COMPUTATION_NAME = "tools/LatencyMonitorDatadog";
    protected static final String NAME = "datadog";
    private static final String DEFAULT_PREFIX = "nuxeo.streams";
    protected String apiKey;
    protected List<String> tags;

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void updateOptions(Options options) {
        options.addOption(Option.builder((String)"l").longOpt("log-name").desc("Monitor consumers latency for this LOG, must be a computation Record, can be a comma separated list of log names or ALL").required().hasArg().argName("LOG_NAME").build());
        options.addOption(Option.builder().longOpt("api-key").desc("Datadog API KEY").required().hasArg().argName("API_KEY").build());
        options.addOption(Option.builder().longOpt("tags").desc("A comma separated list of Datadog tags, for instance: project:foo,staging:bar").hasArg().argName("TAGS").build());
        options.addOption(Option.builder().longOpt("partition").desc("Report metrics for each partition").build());
        options.addOption(Option.builder((String)"i").longOpt("interval").desc("send latency spaced at the specified interval in seconds").hasArg().argName("INTERVAL").build());
        options.addOption(Option.builder((String)"c").longOpt("count").desc("number of times the latency information is sent").hasArg().argName("COUNT").build());
        options.addOption(Option.builder().longOpt("prefix").desc("The metric prefix to use if not nuxeo.streams.").hasArg().argName("PREFIX").build());
        options.addOption(Option.builder().longOpt("codec").desc("Codec used to read record, can be: java, avro, avroBinary, avroJson").hasArg().argName("CODEC").build());
        options.addOption(Option.builder().longOpt("verbose").build());
    }

    @Override
    public boolean run(LogManager manager, CommandLine cmd) {
        this.logNames = this.getLogNames(manager, cmd.getOptionValue("log-name"));
        this.codec = cmd.getOptionValue("codec");
        this.verbose = cmd.hasOption("verbose");
        this.interval = Integer.parseInt(cmd.getOptionValue("interval", "60"));
        this.count = Integer.parseInt(cmd.getOptionValue("count", "-1"));
        this.apiKey = cmd.getOptionValue("api-key");
        this.tags = this.getTags(cmd.getOptionValue("tags"));
        this.prefix = cmd.getOptionValue("prefix", this.getDefaultPrefix());
        this.initTopology(manager);
        return this.runProcessor(manager);
    }

    protected List<String> getTags(String tags) {
        if (tags == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(tags.split(",")).map(String::trim).collect(Collectors.toList());
    }

    @Override
    protected void initTopology(LogManager manager) {
        this.topology = Topology.builder().addComputation(() -> new LatencyDatadogComputation(manager, this.logNames, this.apiKey, this.tags, this.prefix, COMPUTATION_NAME, this.interval, this.count, this.partition, this.verbose, this.getRecordCodec(this.codec)), Collections.singletonList("i1:log_null")).build();
    }

    @Override
    public String getDefaultPrefix() {
        return DEFAULT_PREFIX;
    }
}

