/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.tools.command;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.coursera.metrics.datadog.model.DatadogGauge;
import org.coursera.metrics.datadog.transport.HttpTransport;
import org.coursera.metrics.datadog.transport.Transport;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.computation.ComputationContext;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.log.Latency;
import org.nuxeo.lib.stream.log.LogManager;
import org.nuxeo.lib.stream.log.Name;
import org.nuxeo.lib.stream.log.internals.LogPartitionGroup;
import org.nuxeo.lib.stream.tools.command.LatencyTrackerComputation;

public class LatencyDatadogComputation
extends LatencyTrackerComputation {
    private static final Log log = LogFactory.getLog(LatencyDatadogComputation.class);
    protected static final String HOSTNAME_UNKNOWN = "unknown";
    protected final String apiKey;
    protected final List<String> tags;
    protected final String basePrefix;
    protected final boolean partition;
    protected final String hostname;
    protected HttpTransport transport;

    public LatencyDatadogComputation(LogManager manager, List<Name> logNames, String apiKey, List<String> tags, String basePrefix, String computationName, int intervalSecond, int count, boolean partition, boolean verbose, Codec<Record> codec) {
        super(manager, logNames, computationName, intervalSecond, count, verbose, codec, 0);
        this.apiKey = apiKey;
        this.tags = tags;
        this.basePrefix = basePrefix;
        this.partition = partition;
        this.hostname = this.getHostName();
    }

    protected String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName().split("\\.")[0];
        }
        catch (UnknownHostException e) {
            return HOSTNAME_UNKNOWN;
        }
    }

    @Override
    public void init(ComputationContext context) {
        super.init(context);
        this.transport = new HttpTransport.Builder().withApiKey(this.apiKey).build();
    }

    @Override
    protected void processLatencies(ComputationContext context, LogPartitionGroup logGroup, List<Latency> latencies) {
        Latency groupLatency = Latency.of(latencies);
        this.publishMetrics(groupLatency, this.basePrefix, "all", logGroup.name, logGroup.group);
        if (!this.partition) {
            return;
        }
        for (int part = 0; part < latencies.size(); ++part) {
            this.publishMetrics(groupLatency, this.basePrefix, String.format("%02d", part), logGroup.name, logGroup.group);
        }
    }

    protected void publishMetrics(Latency latency, String prefix, String partition, Name stream, Name group) {
        if (this.verbose) {
            log.info((Object)latency.toString());
        }
        long metricTime = latency.upper() / 1000L;
        ArrayList<Object> mTags = new ArrayList<Object>(this.tags.size() + 3);
        mTags.addAll(this.tags);
        mTags.add("stream:" + stream);
        mTags.add("consumer:" + group);
        mTags.add("partition:" + partition);
        try {
            Transport.Request request = this.transport.prepare();
            request.addGauge(new DatadogGauge(prefix + ".lag", (Number)latency.lag().lag(), Long.valueOf(metricTime), this.hostname, mTags));
            request.addGauge(new DatadogGauge(prefix + ".end", (Number)latency.lag().upper(), Long.valueOf(metricTime), this.hostname, mTags));
            request.addGauge(new DatadogGauge(prefix + ".pos", (Number)latency.lag().lower(), Long.valueOf(metricTime), this.hostname, mTags));
            request.addGauge(new DatadogGauge(prefix + ".latency", (Number)latency.latency(), Long.valueOf(metricTime), this.hostname, mTags));
            request.send();
        }
        catch (IOException e) {
            log.error((Object)("Fail to prepare metric to datadog " + prefix + " " + latency), (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)("Fail to send metric to datadog " + prefix + " " + latency), (Throwable)e);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.transport != null) {
            try {
                this.transport.close();
            }
            catch (IOException e) {
                log.debug((Object)"Error when closing Datadog client: ", (Throwable)e);
            }
            this.transport = null;
        }
    }
}

