/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.io.impl;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.platform.io.api.IOManager;
import org.nuxeo.ecm.platform.io.api.IOResourceAdapter;
import org.nuxeo.ecm.platform.io.impl.IOManagerImpl;
import org.nuxeo.runtime.RuntimeMessage;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class IOManagerComponent
extends DefaultComponent {
    private static final Logger log = LogManager.getLogger(IOManagerComponent.class);
    public static final ComponentName NAME = new ComponentName(IOManagerComponent.class.getName());
    public static final String ADAPTERS_EP_NAME = "adapters";
    private IOManager service;

    public void start(ComponentContext context) {
        this.service = new IOManagerImpl();
        this.getRegistryContributions(ADAPTERS_EP_NAME).forEach(desc -> {
            String name = desc.getName();
            try {
                IOResourceAdapter adapter = desc.getKlass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                adapter.setProperties(desc.getProperties());
                this.service.addAdapter(name, adapter);
                log.info("IO resource adapter {} registered", (Object)name);
            }
            catch (ReflectiveOperationException e) {
                String msg = String.format("Error instantiating adapter '%s' (%s)", name, e.getMessage());
                this.addRuntimeMessage(RuntimeMessage.Level.ERROR, msg);
                log.error((Object)e, (Throwable)e);
            }
        });
    }

    public void stop(ComponentContext context) throws InterruptedException {
        this.service = null;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(IOManager.class)) {
            return (T)this.service;
        }
        return null;
    }
}

