/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb;

import org.sat4j.core.VecInt;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.PBSolverDecorator;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;

public class OptToPBSATAdapter
extends PBSolverDecorator {
    private static final long serialVersionUID = 1L;
    IOptimizationProblem problem;
    boolean modelComputed = false;
    private final IVecInt assumps = new VecInt();
    private long begin;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.pb.OptToPBSATAdapter");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public OptToPBSATAdapter(IOptimizationProblem problem) {
        super((IPBSolver)problem);
        this.problem = problem;
    }

    public boolean isSatisfiable() throws TimeoutException {
        this.modelComputed = false;
        this.assumps.clear();
        this.begin = System.currentTimeMillis();
        if (this.problem.hasNoObjectiveFunction()) {
            this.modelComputed = this.problem.isSatisfiable();
            return this.modelComputed;
        }
        return this.problem.admitABetterSolution();
    }

    public boolean isSatisfiable(boolean global) throws TimeoutException {
        return this.isSatisfiable();
    }

    public boolean isSatisfiable(IVecInt myAssumps, boolean global) throws TimeoutException {
        return this.isSatisfiable(myAssumps);
    }

    public boolean isSatisfiable(IVecInt myAssumps) throws TimeoutException {
        this.modelComputed = false;
        this.assumps.clear();
        myAssumps.copyTo(this.assumps);
        this.begin = System.currentTimeMillis();
        if (this.problem.hasNoObjectiveFunction()) {
            this.modelComputed = this.problem.isSatisfiable(myAssumps);
            return this.modelComputed;
        }
        return this.problem.admitABetterSolution(myAssumps);
    }

    public int[] model() {
        if (this.modelComputed) {
            return this.problem.model();
        }
        try {
            if (!$assertionsDisabled && !this.problem.admitABetterSolution(this.assumps)) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.problem.hasNoObjectiveFunction()) {
                throw new AssertionError();
            }
            do {
                this.problem.discardCurrentSolution();
                if (!this.isVerbose()) continue;
                System.out.println(String.valueOf(this.getLogPrefix()) + "Current objective function value: " + this.problem.getObjectiveValue() + "(" + (double)(System.currentTimeMillis() - this.begin) / 1000.0 + "s)");
            } while (this.problem.admitABetterSolution(this.assumps));
        }
        catch (TimeoutException timeoutException) {
            if (this.isVerbose()) {
                System.out.println(String.valueOf(this.getLogPrefix()) + "Solver timed out after " + (double)(System.currentTimeMillis() - this.begin) / 1000.0 + "s)");
            }
        }
        catch (ContradictionException contradictionException) {}
        this.modelComputed = true;
        return this.problem.model();
    }

    public boolean model(int var) {
        if (!this.modelComputed) {
            this.model();
        }
        return this.problem.model(var);
    }

    public String toString(String prefix) {
        return String.valueOf(prefix) + "Optimization to Pseudo Boolean adapter\n" + super.toString(prefix);
    }

    public boolean isOptimal() {
        return this.problem.isOptimal();
    }
}

