/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs;

import java.io.Serializable;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.nuxeo.ecm.core.bulk.BulkService;
import org.nuxeo.ecm.core.bulk.message.BulkStatus;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="bulkActionFramework")
public class BulkActionFrameworkObject
extends DefaultObject {
    @GET
    @Path(value="{commandId}")
    @Produces(value={"application/json"})
    public BulkStatus getBulkStatus(@PathParam(value="commandId") String commandId) {
        BulkStatus status = (BulkStatus)((BulkService)Framework.getService(BulkService.class)).getStatus((Serializable)((Object)commandId));
        this.checkStatus(status);
        return status;
    }

    @PUT
    @Path(value="{commandId}/abort")
    @Produces(value={"application/json"})
    public BulkStatus abortBulkAction(@PathParam(value="commandId") String commandId) {
        BulkStatus status = (BulkStatus)((BulkService)Framework.getService(BulkService.class)).getStatus((Serializable)((Object)commandId));
        this.checkStatus(status);
        return (BulkStatus)((BulkService)Framework.getService(BulkService.class)).abort((Serializable)((Object)commandId));
    }

    protected void checkStatus(BulkStatus status) {
        if (status.getState() == BulkStatus.State.UNKNOWN || !this.getContext().getPrincipal().isAdministrator() && !this.getContext().getPrincipal().getName().equals(status.getUsername())) {
            throw new WebResourceNotFoundException("Bulk command with id=" + status.getId() + " doesn't exist");
        }
    }
}

