/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.adapters;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.core.util.Paginable;
import org.nuxeo.ecm.automation.core.util.PaginablePageProvider;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.webengine.model.impl.DefaultAdapter;
import org.nuxeo.runtime.api.Framework;

public abstract class PaginableAdapter<T>
extends DefaultAdapter {
    protected Long currentPageIndex;
    protected Long pageSize;
    protected String maxResults;
    protected String sortBy;
    protected String sortOrder;

    protected void initialize(Object ... args) {
        super.initialize(args);
        HttpServletRequest request = this.ctx.getRequest();
        this.currentPageIndex = this.extractLongParam(request, "currentPageIndex", 0L);
        this.pageSize = this.extractLongParam(request, "pageSize", 50L);
        this.maxResults = request.getParameter("maxResults");
        this.sortBy = request.getParameter("sortBy");
        this.sortOrder = request.getParameter("sortOrder");
    }

    public <A> A getAdapter(Class<A> adapter) {
        if (adapter.isAssignableFrom(DocumentModelList.class)) {
            return adapter.cast(this.getPaginableEntries());
        }
        return (A)super.getAdapter(adapter);
    }

    protected abstract PageProviderDefinition getPageProviderDefinition();

    protected Object[] getParams() {
        return new Object[0];
    }

    protected DocumentModel getSearchDocument() {
        return null;
    }

    @GET
    public Paginable<T> getPaginableEntries() {
        PageProviderDefinition ppDefinition = this.getPageProviderDefinition();
        if (ppDefinition == null) {
            throw new NuxeoException("Page provider given not found");
        }
        PageProviderService pps = (PageProviderService)Framework.getService(PageProviderService.class);
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)this.ctx.getCoreSession());
        ArrayList<SortInfo> sortInfos = null;
        if (!StringUtils.isBlank((CharSequence)this.sortBy)) {
            String[] sorts = this.sortBy.split(",");
            String[] orders = null;
            if (!StringUtils.isBlank((CharSequence)this.sortOrder)) {
                orders = this.sortOrder.split(",");
            }
            sortInfos = new ArrayList<SortInfo>(sorts.length);
            for (int i = 0; i < sorts.length; ++i) {
                String sort = sorts[i];
                boolean sortAscending = orders != null && orders.length > i && "asc".equals(orders[i].toLowerCase());
                sortInfos.add(new SortInfo(sort, sortAscending));
            }
        }
        PageProvider pp = pps.getPageProvider("", ppDefinition, this.getSearchDocument(), sortInfos, this.pageSize, this.currentPageIndex, props, this.getParams());
        return this.getPaginableEntries(pp);
    }

    protected Paginable<T> getPaginableEntries(PageProvider<T> pageProvider) {
        return new PaginablePageProvider(pageProvider);
    }

    protected Long extractLongParam(HttpServletRequest request, String paramName, Long defaultValue) {
        String strParam = request.getParameter(paramName);
        return strParam == null ? defaultValue : Long.valueOf(strParam);
    }
}

